/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.crypto;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import ru.rutoken.crypto.Cipher;
import ru.rutoken.crypto.CipherInterface;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.spec.ParamRandom;
import ru.rutoken.tools.Arrays;

public class CipherSpi
extends javax.crypto.CipherSpi
implements Cleanable {
    protected final CipherInterface implementation;

    public CipherSpi(CipherInterface cipherInterface) {
        this.implementation = cipherInterface;
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.implementation.setMode(Cipher.getMode(string));
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        this.implementation.setPadding(Cipher.getPadding(string));
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.implementation.getKeySize(key);
    }

    protected int engineGetBlockSize() {
        return this.implementation.getBlockSize();
    }

    protected int engineGetOutputSize(int n) {
        return this.implementation.getOutputSize(n);
    }

    protected byte[] engineGetIV() {
        return this.implementation.getIV();
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.implementation.setParameter(algorithmParameterSpec);
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key == Cleaner.CleanSecretKey.INSTANCE) {
            Cleaner.clean(this);
        } else {
            this.implementation.setOperationMode(n);
            if (secureRandom != null) {
                ParamRandom paramRandom = null;
                try {
                    paramRandom = new ParamRandom(secureRandom);
                    this.implementation.setParameter(paramRandom);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new InvalidKeyException(invalidAlgorithmParameterException);
                }
                finally {
                    if (paramRandom != null) {
                        Cleaner.clean(paramRandom);
                    }
                }
            }
            this.implementation.init(key);
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.implementation.setOperationMode(n);
        try {
            this.implementation.setParameter(algorithmParameterSpec);
            this.implementation.setParameter(new ParamRandom(secureRandom));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException);
        }
        this.implementation.init(key);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = this.implementation.getOutputSize(n2);
        byte[] byArray2 = new byte[n4];
        try {
            n3 = this.implementation.update(byArray, n, n2, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException(shortBufferException);
        }
        if (n3 != n4) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.implementation.update(byArray, n, n2, byArray2, n3);
    }

    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        try {
            return this.bufferCrypt(byteBuffer, byteBuffer2, true);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new ProviderException("Internal error in update()");
        }
        catch (BadPaddingException badPaddingException) {
            throw new ProviderException("Internal error in update()");
        }
    }

    private int bufferCrypt(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n;
        byte[] byArray;
        int n2;
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new NullPointerException("Input and output buffers must not be null");
        }
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (bl && n2 == 0) {
            return 0;
        }
        int n5 = this.engineGetOutputSize(n2);
        if (byteBuffer2.remaining() < n5) {
            throw new ShortBufferException("Need at least " + n5 + " bytes of space in output buffer");
        }
        boolean bl2 = byteBuffer.hasArray();
        boolean bl3 = byteBuffer2.hasArray();
        if (bl2 && bl3) {
            byte[] byArray2 = byteBuffer.array();
            int n6 = byteBuffer.arrayOffset() + n3;
            byte[] byArray3 = byteBuffer2.array();
            int n7 = byteBuffer2.position();
            int n8 = byteBuffer2.arrayOffset() + n7;
            int n9 = bl ? this.engineUpdate(byArray2, n6, n2, byArray3, n8) : this.engineDoFinal(byArray2, n6, n2, byArray3, n8);
            byteBuffer.position(n4);
            byteBuffer2.position(n7 + n9);
            return n9;
        }
        if (!bl2 && bl3) {
            int n10;
            int n11 = byteBuffer2.position();
            byte[] byArray4 = byteBuffer2.array();
            int n12 = byteBuffer2.arrayOffset() + n11;
            byte[] byArray5 = new byte[Arrays.getTempArraySize(n2)];
            int n13 = 0;
            for (n2 = n4 - n3; n2 > 0; n2 -= n10) {
                n10 = Math.min(n2, byArray5.length);
                byteBuffer.get(byArray5, 0, n10);
                int n14 = bl || n2 != n10 ? this.engineUpdate(byArray5, 0, n10, byArray4, n12) : this.engineDoFinal(byArray5, 0, n10, byArray4, n12);
                n13 += n14;
                n12 += n14;
            }
            byteBuffer2.position(n11 + n13);
            return n13;
        }
        if (bl2) {
            byArray = byteBuffer.array();
            n = byteBuffer.arrayOffset() + n3;
        } else {
            byArray = new byte[Arrays.getTempArraySize(n2)];
            n = 0;
        }
        byte[] byArray6 = new byte[Arrays.getTempArraySize(n5)];
        int n15 = byArray6.length;
        int n16 = 0;
        boolean bl4 = false;
        while (n2 > 0) {
            int n17 = Math.min(n2, n15);
            if (!bl2 && !bl4) {
                byteBuffer.get(byArray, 0, n17);
                n = 0;
            }
            try {
                int n18 = bl || n2 != n17 ? this.engineUpdate(byArray, n, n17, byArray6, 0) : this.engineDoFinal(byArray, n, n17, byArray6, 0);
                bl4 = false;
                n += n17;
                n2 -= n17;
                byteBuffer2.put(byArray6, 0, n18);
                n16 += n18;
            }
            catch (ShortBufferException shortBufferException) {
                if (bl4) {
                    throw (ProviderException)new ProviderException("Could not determine buffer size").initCause(shortBufferException);
                }
                bl4 = true;
                int n19 = this.engineGetOutputSize(n17);
                byArray6 = new byte[n19];
            }
        }
        byteBuffer.position(n4);
        return n16;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3;
        int n4 = this.implementation.getOutputSize(n2);
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        try {
            if (n2 != 0) {
                n5 = this.implementation.update(byArray, n, n2, byArray2, 0);
            }
            n3 = this.implementation.doFinal(byArray2, n5);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException();
        }
        if (n4 != n3 + n5) {
            byte[] byArray3 = new byte[n3 + n5];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            byArray2 = byArray3;
        }
        this.implementation.reset();
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4 = this.implementation.update(byArray, n, n2, byArray2, n3);
        int n5 = this.implementation.doFinal(byArray2, n3 + n4);
        this.implementation.reset();
        return n4 + n5;
    }

    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n = this.bufferCrypt(byteBuffer, byteBuffer2, false);
        this.implementation.reset();
        return n;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.implementation.wrap(key);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.implementation.unwrap(byArray, string, n);
    }

    public void engineReset() {
        this.implementation.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        return new CipherSpi((CipherInterface)this.implementation.clone());
    }

    public String toString() {
        return this.implementation.toString();
    }

    public void clean() {
        Cleaner.clean(this.implementation);
    }
}

