/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import ru.rutoken.security.Cleanable;
import ru.rutoken.tools.Platform;

public class Config
implements AlgorithmParameterSpec,
Cleanable {
    public static final String PROPERTY = Config.class.getName();
    public static final int SERIAL_LENGTH = 16;
    public static final char SEPARATOR = '=';
    public static final String LIBRARY = "Library";
    public static final String SERIAL = "Serial";
    public static final String PIN = "Pin";
    protected String library;
    protected String serial;
    protected char[] pin;

    public Config() {
    }

    public Config(String string, String string2, String string3) {
        this.library = string == null || string.length() == 0 ? null : string;
        this.serial = string2 == null || string2.length() == 0 ? null : Config.expand(string2, 16);
        this.pin = string3 == null || string3.length() == 0 ? null : string3.toCharArray();
    }

    public Config(String string) throws IOException {
        this.load(string);
    }

    public Config(File file) throws IOException {
        this.load(file);
    }

    public Config(InputStream inputStream) throws IOException {
        this.load(inputStream);
    }

    public String getLibrary() {
        return this.library == null ? Config.getDefaultLibrary() : this.library;
    }

    public void setLibrary(String string) {
        this.library = string == null || string.length() == 0 ? null : string;
    }

    public String getSerial() {
        return this.serial == null ? Config.getDefaultSerial() : this.serial;
    }

    public void setSerial(String string) {
        this.serial = string == null || string.length() == 0 ? null : Config.expand(string, 16);
    }

    public String getPin() {
        return this.pin == null ? Config.getDefaultPin() : new String(this.pin);
    }

    public void setPin(String string) {
        this.pin = string == null || string.length() == 0 ? null : string.toCharArray();
    }

    public void load(String string) throws IOException {
        this.load(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        if (file != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                this.load(fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                this.readStream(bufferedReader);
            }
            finally {
                bufferedReader.close();
            }
        } else {
            throw new IOException();
        }
    }

    public void save(String string) throws IOException {
        this.save(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.save(fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            PrintStream printStream = new PrintStream(outputStream);
            try {
                printStream.print(this.toString());
            }
            finally {
                printStream.close();
            }
        } else {
            throw new IOException();
        }
    }

    protected void readStream(BufferedReader bufferedReader) throws IOException {
        Properties properties = Config.readPropertiesFromStream(bufferedReader);
        this.setLibrary((String)properties.get(LIBRARY));
        this.setSerial((String)properties.get(SERIAL));
        this.setPin((String)properties.get(PIN));
    }

    protected static Properties readPropertiesFromStream(BufferedReader bufferedReader) throws IOException {
        Properties properties = new Properties();
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.trim().length() != 0) {
                int n = string.indexOf(61);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                properties.put(string2, string3);
            }
            string = bufferedReader.readLine();
        }
        return properties;
    }

    public static String expand(String string, int n) {
        if (string.length() != n) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[n];
            for (int i = 0; i < cArray2.length; ++i) {
                cArray2[i] = 32;
            }
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length > cArray2.length ? cArray2.length : cArray.length);
            return new String(cArray2);
        }
        return string;
    }

    public static String getDefaultLibrary() {
        String string = Platform.getProperty(PROPERTY + LIBRARY);
        return string == null || string.length() == 0 ? Config.getSystemLibrary() : string;
    }

    public static void setDefaultLibrary(String string) {
        Platform.setProperty(PROPERTY + LIBRARY, string);
    }

    public static String getDefaultSerial() {
        String string = Platform.getProperty(PROPERTY + SERIAL);
        return string == null || string.length() == 0 ? null : Config.expand(string, 16);
    }

    public static void setDefaultSerial(String string) {
        Platform.setProperty(PROPERTY + SERIAL, string);
    }

    public static String getDefaultPin() {
        String string = Platform.getProperty(PROPERTY + PIN);
        return string == null || string.length() == 0 ? null : string;
    }

    public static void setDefaultPin(String string) {
        Platform.setProperty(PROPERTY + PIN, string);
    }

    public void setDefault() {
        String string = this.getLibrary();
        String string2 = this.getSerial();
        String string3 = this.getPin();
        Config.setDefaultLibrary(string == null ? "" : string);
        Config.setDefaultSerial(string2 == null ? "" : string2);
        Config.setDefaultPin(string3 == null ? "" : string3);
    }

    public static void cleanDefault() {
        Config.setDefaultLibrary("");
        Config.setDefaultSerial("");
        Config.setDefaultPin("");
    }

    public static String getSystemLibrary() {
        String string = Platform.getProperty("os.name");
        String string2 = null;
        if (string.contains("Windows")) {
            string2 = "C:\\Windows\\System32\\rtPKCS11ECP.dll";
        }
        if (string2 != null && new File(string2).exists()) {
            return string2;
        }
        return null;
    }

    public String toString() {
        String string = this.getLibrary();
        String string2 = this.getSerial();
        String string3 = this.getPin();
        return "Library=" + (string == null ? "" : string) + "\r\n" + SERIAL + '=' + (string2 == null ? "" : string2) + "\r\n" + PIN + '=' + (string3 == null ? "" : string3) + "\r\n" + "\r\n";
    }

    public void clean() {
        for (int i = 0; i < this.pin.length; ++i) {
            this.pin[i] = '\u0000';
        }
    }
}

