/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import ru.rutoken.crypto.CipherInterface;
import ru.rutoken.crypto.CipherKeyInterface;
import ru.rutoken.crypto.KeyBlob;
import ru.rutoken.crypto.SecretKeyInterface;
import ru.rutoken.crypto.SpecSecretKey;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.impl.Rt11CipherKey;
import ru.rutoken.jrt11.impl.Rt11SecretKey;
import ru.rutoken.security.Cleaner;
import ru.rutoken.tools.Arrays;

public class GostCipher11
implements CipherInterface {
    public static final String ALGORITHM_NAME = "rt11GOST28147";
    public static final int STEP_LENGTH = 8;
    protected int mode;
    protected int padding;
    protected int operationMode;
    protected long processedLength = 0L;
    protected byte[] ivBytes;
    protected AlgorithmParameterSpec algorithmParameter;
    protected CipherKeyInterface secret;
    protected CipherKeyInterface saved;

    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    public long getProcessedLength() {
        return this.processedLength;
    }

    public AlgorithmParameterSpec getParameter() {
        return this.algorithmParameter;
    }

    public int getBlockSize() {
        return 8;
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            this.ivBytes = ((IvParameterSpec)algorithmParameterSpec).getIV();
        } else {
            this.algorithmParameter = algorithmParameterSpec;
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) throws NoSuchAlgorithmException {
        if (n != 1 && n != 2) {
            throw new UnsupportedOperationException();
        }
        this.mode = n;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int n) throws NoSuchPaddingException {
        if (n != 1) {
            throw new UnsupportedOperationException();
        }
        this.padding = n;
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof Rt11SecretKey) {
            return 256;
        }
        throw new InvalidKeyException();
    }

    public void setOperationMode(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException();
        }
        this.operationMode = n;
    }

    public void reset() {
        if (this.secret != null) {
            Cleaner.clean(this.secret);
            this.secret = null;
        }
        try {
            this.secret = (CipherKeyInterface)this.saved.clone();
            if (this.operationMode == 1) {
                this.secret.encryptInit(this);
            } else if (this.operationMode == 2) {
                this.secret.decryptInit(this);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenException(cloneNotSupportedException);
        }
        this.processedLength = 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(Key key) throws InvalidKeyException {
        this.onInit();
        if (!(key instanceof SpecSecretKey)) throw new InvalidKeyException();
        SecretKeyInterface secretKeyInterface = ((SpecSecretKey)key).getImpl();
        if (!(secretKeyInterface instanceof Rt11SecretKey)) throw new InvalidKeyException();
        try {
            if (this.saved != null) {
                Cleaner.clean(this.saved);
                this.saved = null;
            }
            if (this.secret != null) {
                Cleaner.clean(this.secret);
                this.secret = null;
            }
            this.saved = new Rt11CipherKey((Rt11SecretKey)secretKeyInterface);
            this.reset();
            return;
        }
        catch (Exception exception) {
            throw new TokenException(exception);
        }
    }

    protected void onInit() {
        if (this.mode == 0) {
            throw new IllegalStateException();
        }
    }

    public int getOutputSize(int n) {
        if (this.mode == 3 || this.mode == 2) {
            return n;
        }
        return n;
    }

    public byte[] getIV() {
        return this.ivBytes == null ? null : (byte[])this.ivBytes.clone();
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.onUpdate();
        int n4 = 0;
        if (this.operationMode == 1) {
            n4 = this.secret.encryptUpdate(byArray, n, n2, byArray2, n3, byArray2.length);
        } else if (this.operationMode == 2) {
            n4 = this.secret.decryptUpdate(byArray, n, n2, byArray2, n3, byArray2.length);
        }
        this.processedLength += (long)n4;
        return n4;
    }

    public int doFinal(byte[] byArray, int n) throws ShortBufferException {
        this.onUpdate();
        int n2 = 0;
        if (this.operationMode == 1) {
            n2 = this.secret.encryptFinal(byArray, n, byArray.length);
        } else if (this.operationMode == 2) {
            n2 = this.secret.decryptFinal(byArray, n, byArray.length);
        }
        return n2;
    }

    protected void onUpdate() {
        if (this.secret == null) {
            throw new IllegalStateException();
        }
        if (this.ivBytes == null) {
            throw new IllegalStateException();
        }
        if (this.operationMode == 0) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.operationMode != 3) {
            throw new IllegalStateException();
        }
        if (key instanceof SpecSecretKey) {
            SecretKeyInterface secretKeyInterface = ((SpecSecretKey)key).getImpl();
            if (secretKeyInterface instanceof Rt11SecretKey) {
                KeyBlob keyBlob = null;
                try {
                    keyBlob = this.secret.wrap(secretKeyInterface, null);
                    byte[] byArray = keyBlob.encode();
                    return byArray;
                }
                finally {
                    if (keyBlob != null) {
                        Cleaner.clean(keyBlob);
                    }
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key unwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.operationMode != 4) {
            throw new IllegalStateException();
        }
        KeyBlob keyBlob = null;
        try {
            keyBlob = new KeyBlob(byArray);
            Key key = this.secret.unwrap(keyBlob, null);
            return key;
        }
        finally {
            if (keyBlob != null) {
                Cleaner.clean(keyBlob);
            }
        }
    }

    public void clean() {
        this.processedLength = 0L;
        if (this.ivBytes != null) {
            Arrays.clean(this.ivBytes);
            this.ivBytes = null;
        }
        Cleaner.clean(this.algorithmParameter);
        this.algorithmParameter = null;
        if (this.secret != null) {
            Cleaner.clean(this.secret);
            this.secret = null;
        }
        if (this.saved != null) {
            Cleaner.clean(this.saved);
            this.saved = null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

