/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import ru.rutoken.crypto.KeyGenInterface;
import ru.rutoken.crypto.SpecSecretKey;
import ru.rutoken.jrt11.SessionFactory;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.impl.Rt11SecretKey;
import ru.rutoken.jrt11.level11.Attribute;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.spec.gost.CryptParamFactory;
import ru.rutoken.tools.Arrays;

public class GostKeyGen11
implements KeyGenInterface,
Cleanable {
    public static final String ALGORITHM_NAME = "rt11GOST28147";
    protected SessionFactory sessionFactory = new SessionFactory();
    protected AlgorithmParameterSpec algorithmParameter;
    public static final AttributeList CREATE_ATTRIBUTES = new AttributeList(new Attribute[]{Attribute.CLASS_SECRET_KEY, Attribute.TOKEN_FALSE, Attribute.PRIVATE_FALSE, Attribute.KEY_TYPE_GOST28147, Attribute.EXTRACTABLE_TRUE, Attribute.MODIFIABLE_TRUE});

    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    public AlgorithmParameterSpec getParameter() {
        return this.algorithmParameter;
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!this.sessionFactory.setParameter(algorithmParameterSpec)) {
            this.algorithmParameter = algorithmParameterSpec;
        }
    }

    public void reset() {
    }

    public SecretKey generateKey() {
        byte[] byArray = new byte[32];
        try {
            Session session = (Session)this.sessionFactory.getSession();
            session.randomGenerate(byArray);
            Rt11SecretKey rt11SecretKey = new Rt11SecretKey(session, null, null, byArray, CryptParamFactory.getInstance());
            SpecSecretKey specSecretKey = new SpecSecretKey(rt11SecretKey);
            return specSecretKey;
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
        finally {
            Arrays.clean(byArray);
        }
    }

    public void clean() {
        this.algorithmParameter = null;
    }
}

