/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.KeyPair;
import ru.rutoken.jrt11.impl.GostPrivateKey11;
import ru.rutoken.jrt11.impl.GostPublicKey11;
import ru.rutoken.jrt11.impl.PairGenerator11;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.SpecPrivateKey;
import ru.rutoken.security.SpecPublicKey;
import ru.rutoken.security.spec.gost.EllipticParamInterface;
import ru.rutoken.security.spec.gost.ExchangeParamFactory;
import ru.rutoken.security.spec.gost.ExchangeParamInterface;

public class GostPairGenerator11
extends PairGenerator11 {
    public static final String ALGORITHM_NAME = "rtGOST3410";

    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    protected Mechanism getMechanism() {
        return Mechanism.GENERATOR_GOST3410;
    }

    protected AttributeList getPublicPattern() {
        ExchangeParamInterface exchangeParamInterface = this.algorithmParameter instanceof EllipticParamInterface ? (EllipticParamInterface)this.algorithmParameter : ExchangeParamFactory.getInstance();
        return GostPublicKey11.getCreatePattern(this.id, this.alias, exchangeParamInterface);
    }

    protected AttributeList getPrivatePattern() {
        ExchangeParamInterface exchangeParamInterface = this.algorithmParameter instanceof EllipticParamInterface ? (EllipticParamInterface)this.algorithmParameter : ExchangeParamFactory.getInstance();
        return GostPrivateKey11.getCreatePattern(this.id, this.alias, exchangeParamInterface);
    }

    protected KeyPair generateKeyPair(TokenObj[] tokenObjArray) throws P11Exception {
        GostPublicKey11 gostPublicKey11 = new GostPublicKey11(tokenObjArray[0]);
        GostPrivateKey11 gostPrivateKey11 = new GostPrivateKey11(tokenObjArray[1]);
        return new KeyPair(new SpecPublicKey(gostPublicKey11), new SpecPrivateKey(gostPrivateKey11));
    }
}

