/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import ru.rutoken.crypto.SecretKeyInterface;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.impl.PrivateKey11;
import ru.rutoken.jrt11.impl.Rt11SecretKey;
import ru.rutoken.jrt11.level11.Attribute;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.PrivateKeyInterface;
import ru.rutoken.security.PublicKeyInterface;
import ru.rutoken.security.spec.gost.EllipticParamFactory;
import ru.rutoken.security.spec.gost.EllipticParamInterface;
import ru.rutoken.security.spec.gost.ExchangeParamFactory;
import ru.rutoken.security.spec.gost.ExchangeParamInterface;
import ru.rutoken.tools.Arrays;

public class GostPrivateKey11
extends PrivateKey11 {
    public static final AttributeList CREATE_ATTRIBUTES = new AttributeList(new Attribute[]{Attribute.CLASS_PRIVATE_KEY, Attribute.TOKEN_TRUE, Attribute.PRIVATE_TRUE, Attribute.KEY_TYPE_GOSTR3410, Attribute.SIGN_TRUE, Attribute.GOSTR3410_PARAMS_DEFAULT, Attribute.ID_EMPTY, Attribute.LABEL_EMPTY});
    public static final AttributeList FIND_PRIVATE_KEYS_PATTERN = new AttributeList(new Attribute[]{Attribute.CLASS_PRIVATE_KEY, Attribute.TOKEN_TRUE, Attribute.PRIVATE_TRUE, Attribute.KEY_TYPE_GOSTR3410});
    public static final AttributeList attrGOST28147_89DerivedKey = new AttributeList(new Attribute[]{Attribute.CLASS_SECRET_KEY, Attribute.TOKEN_FALSE, Attribute.PRIVATE_FALSE, Attribute.KEY_TYPE_GOST28147, Attribute.MODIFIABLE_TRUE, Attribute.EXTRACTABLE_TRUE});
    public static final AttributeList attrGOST28147_89KeyToWrap = new AttributeList(new Attribute[]{Attribute.CLASS_SECRET_KEY, Attribute.TOKEN_FALSE, Attribute.KEY_TYPE_GOST28147, Attribute.PRIVATE_FALSE, Attribute.MODIFIABLE_TRUE, Attribute.EXTRACTABLE_TRUE, Attribute.VALUE_NULL});
    public static final AttributeList attrGOST28147_89UnwrappedKey = new AttributeList(new Attribute[]{Attribute.CLASS_SECRET_KEY, Attribute.TOKEN_FALSE, Attribute.KEY_TYPE_GOST28147, Attribute.PRIVATE_FALSE, Attribute.MODIFIABLE_TRUE, Attribute.EXTRACTABLE_TRUE});

    public GostPrivateKey11(TokenObj tokenObj) throws P11Exception {
        super(tokenObj);
    }

    public GostPrivateKey11(Session session, String string, String string2, byte[] byArray, EllipticParamInterface ellipticParamInterface) throws P11Exception {
        super(session.createObject(GostPrivateKey11.getPlaceAttributes(string, string2, byArray, ellipticParamInterface)));
    }

    public String getAlgorithmName() {
        return "rtGOST3410";
    }

    public int getSignatureLength() {
        return 64;
    }

    protected Mechanism getMechanism() {
        return Mechanism.SIGN_GOST3410;
    }

    public static AttributeList getCreatePattern(String string, String string2, EllipticParamInterface ellipticParamInterface) {
        AttributeList attributeList = new AttributeList(CREATE_ATTRIBUTES);
        attributeList.setValue(592L, ellipticParamInterface.getEncodedOID());
        if (ellipticParamInterface instanceof ExchangeParamInterface) {
            attributeList.add(new Attribute(268L, true));
        } else {
            attributeList.add(new Attribute(268L, false));
        }
        if (string != null) {
            attributeList.setValue(258L, string);
        }
        if (string2 != null) {
            attributeList.setValue(3L, string2);
        }
        return attributeList;
    }

    public AlgorithmParameterSpec getParameter() {
        try {
            Object object = this.tokenObject.getAttributeValue(592L);
            if (!(object instanceof byte[]) || ((byte[])object).length != 9) {
                throw new P11Exception("Invalid PublicKey attribute.");
            }
            EllipticParamInterface ellipticParamInterface = null;
            try {
                ellipticParamInterface = ExchangeParamFactory.decode((byte[])object, 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ellipticParamInterface = EllipticParamFactory.decode((byte[])object, 0);
            }
            return ellipticParamInterface;
        }
        catch (P11Exception p11Exception) {
            throw new ProviderException(p11Exception);
        }
    }

    public static GostPrivateKey11 create(Session session, String string, String string2, byte[] byArray, EllipticParamInterface ellipticParamInterface) throws TokenException {
        try {
            AttributeList attributeList = GostPrivateKey11.getPlaceAttributes(string, string2, byArray, ellipticParamInterface);
            TokenObj tokenObj = session.createObject(attributeList);
            return new GostPrivateKey11(tokenObj);
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    public static AttributeList getPlaceAttributes(String string, String string2, byte[] byArray, EllipticParamInterface ellipticParamInterface) {
        AttributeList attributeList = GostPrivateKey11.getCreatePattern(string, string2, ellipticParamInterface);
        return attributeList.add(new Attribute(17L, byArray));
    }

    public SecretKeyInterface generateSecret(PublicKeyInterface publicKeyInterface, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        Rt11SecretKey rt11SecretKey;
        block6: {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new IllegalArgumentException();
            }
            byte[] byArray = ((IvParameterSpec)algorithmParameterSpec).getIV();
            byte[] byArray2 = publicKeyInterface.getValue();
            byte[] byArray3 = GostPrivateKey11.createParamsInt(byArray, byArray2);
            Mechanism mechanism = new Mechanism(4612L, byArray3);
            byte[] byArray4 = null;
            try {
                TokenObj tokenObj = this.tokenObject.getSession().deriveKey(this.tokenObject, mechanism, attrGOST28147_89DerivedKey);
                byArray4 = (byte[])tokenObj.getAttributeValue(17L);
                rt11SecretKey = new Rt11SecretKey(tokenObj, byArray4);
                if (byArray4 == null) break block6;
            }
            catch (P11Exception p11Exception) {
                try {
                    throw new InvalidKeyException(p11Exception);
                }
                catch (Throwable throwable) {
                    if (byArray4 != null) {
                        Arrays.clean(byArray4);
                    }
                    throw throwable;
                }
            }
            Arrays.clean(byArray4);
        }
        return rt11SecretKey;
    }

    public static PrivateKeyInterface[] findPrivateKeys(Session session) throws P11Exception {
        TokenObj[] tokenObjArray = session.findObjects(FIND_PRIVATE_KEYS_PATTERN);
        PrivateKeyInterface[] privateKeyInterfaceArray = new PrivateKeyInterface[tokenObjArray.length];
        for (int i = 0; i < tokenObjArray.length; ++i) {
            privateKeyInterfaceArray[i] = new GostPrivateKey11(tokenObjArray[i]);
        }
        return privateKeyInterfaceArray;
    }

    public static PrivateKeyInterface findKeyById(Session session, String string) throws P11Exception {
        AttributeList attributeList = new AttributeList(FIND_PRIVATE_KEYS_PATTERN);
        attributeList.add(new Attribute(258L, string.getBytes()));
        TokenObj[] tokenObjArray = session.findObjects(attributeList);
        if (tokenObjArray.length > 1) {
            throw new P11Exception("Structure corrupted. Two keys with one name.");
        }
        return tokenObjArray.length == 0 ? null : new GostPrivateKey11(tokenObjArray[0]);
    }

    public static byte[] createParamsInt(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[84];
        int n = 0;
        Arrays.getBytes(-1879048183, byArray3, n);
        Arrays.getBytes(64, byArray3, n += 4);
        System.arraycopy(byArray2, 0, byArray3, n += 4, 64);
        Arrays.getBytes(8, byArray3, n += 64);
        System.arraycopy(byArray, 0, byArray3, n += 4, 8);
        n += 8;
        return byArray3;
    }
}

