/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.crypto.KeyBlob;
import ru.rutoken.crypto.SecretKeyInterface;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.level11.Const11;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.PrivateKeyInterface;
import ru.rutoken.security.PublicKeyInterface;

public abstract class PrivateKey11
implements PrivateKeyInterface,
Const11,
Cleanable {
    protected TokenObj tokenObject = null;

    public PrivateKey11(TokenObj tokenObj) throws P11Exception {
        this.tokenObject = tokenObj;
    }

    protected TokenObj getObject() {
        return this.tokenObject;
    }

    public void delete() {
        try {
            this.tokenObject.delete();
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    public String getId() {
        String string = null;
        try {
            string = new String((byte[])this.tokenObject.getAttributeValue(258L));
        }
        catch (P11Exception p11Exception) {
            // empty catch block
        }
        return string;
    }

    public String getAlias() {
        String string = null;
        try {
            string = new String((byte[])this.tokenObject.getAttributeValue(3L));
        }
        catch (P11Exception p11Exception) {
            // empty catch block
        }
        return string;
    }

    public void clean() {
        Cleaner.clean(this.tokenObject);
    }

    protected abstract Mechanism getMechanism();

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
    }

    public AlgorithmParameterSpec getParameter() {
        return null;
    }

    public PublicKeyInterface generatePublic() throws InvalidKeyException {
        throw new InvalidKeyException();
    }

    public byte[] signature(byte[] byArray) throws SignatureException, InvalidKeyException {
        try {
            return this.tokenObject.sign(byArray, this.getMechanism());
        }
        catch (P11Exception p11Exception) {
            throw new InvalidKeyException(p11Exception);
        }
    }

    public SecretKeyInterface generateSecret(PublicKeyInterface publicKeyInterface, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        return null;
    }

    public KeyBlob exportKey(SecretKeyInterface secretKeyInterface, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        return null;
    }

    public void importKey(KeyBlob keyBlob, SecretKeyInterface secretKeyInterface, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.tokenObject.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

