/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.level11;

import ru.rutoken.jrt11.level11.Attribute;
import ru.rutoken.jrt11.level11.Const11;
import ru.rutoken.security.Cleanable;
import ru.rutoken.tools.Arrays;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;

public class AttributeList
implements Const11,
Cleanable {
    protected CK_ATTRIBUTE[] list;
    public static final AttributeList ANY_ATTRIBUTE = new AttributeList(new Attribute[0]);
    public static final AttributeList TOKEN_ATTRIBUTE = new AttributeList(new Attribute[]{Attribute.TOKEN_TRUE});

    public AttributeList(int n) {
        this.list = new CK_ATTRIBUTE[n];
    }

    protected AttributeList(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        if (cK_ATTRIBUTEArray == null) {
            throw new IllegalArgumentException();
        }
        this.list = cK_ATTRIBUTEArray;
    }

    public AttributeList(Attribute[] attributeArray) {
        this.list = new CK_ATTRIBUTE[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            this.list[i] = attributeArray[i].attribute;
        }
    }

    public AttributeList(AttributeList attributeList) {
        this.list = new CK_ATTRIBUTE[attributeList.list.length];
        System.arraycopy(attributeList.list, 0, this.list, 0, attributeList.list.length);
    }

    public int size() {
        return this.list.length;
    }

    public Attribute get(int n) {
        return new Attribute(this.list[n]);
    }

    public void set(int n, Attribute attribute) {
        this.list[n] = attribute.attribute;
    }

    public AttributeList add(Attribute attribute) {
        int n = this.list.length;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[n + 1];
        System.arraycopy(this.list, 0, cK_ATTRIBUTEArray, 0, n);
        cK_ATTRIBUTEArray[n] = attribute.attribute;
        this.list = cK_ATTRIBUTEArray;
        return this;
    }

    public Object getValue(long l) {
        Object object = null;
        for (CK_ATTRIBUTE cK_ATTRIBUTE : this.list) {
            if (cK_ATTRIBUTE.type != l) continue;
            object = cK_ATTRIBUTE.pValue;
            break;
        }
        return object;
    }

    public void setValue(long l, Object object) {
        for (CK_ATTRIBUTE cK_ATTRIBUTE : this.list) {
            if (cK_ATTRIBUTE.type != l) continue;
            cK_ATTRIBUTE.pValue = object;
            return;
        }
        this.add(new Attribute(l, object));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CK_ATTRIBUTE cK_ATTRIBUTE : this.list) {
            Attribute.print(cK_ATTRIBUTE, stringBuilder);
            stringBuilder.append(NEWLINE);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof AttributeList && this.list != null && ((AttributeList)object).list != null && this.list.length == ((AttributeList)object).list.length) {
            int n = this.list.length;
            AttributeList attributeList = (AttributeList)object;
            bl = true;
            for (int i = 0; i < n; ++i) {
                if (this.list[i].equals(attributeList.list[i])) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public void clean() {
        for (CK_ATTRIBUTE cK_ATTRIBUTE : this.list) {
            this.clean(cK_ATTRIBUTE.pValue);
        }
    }

    public void clean(Object object) {
        if (object instanceof byte[]) {
            Arrays.clean((byte[])object);
        } else if (object instanceof char[]) {
            Arrays.clean((char[])object);
        }
    }
}

