/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.level11;

import java.lang.reflect.Method;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.jrt11.Config;
import ru.rutoken.jrt11.level11.ContextInfo;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.SlotInfo;
import ru.rutoken.jrt11.level11.Token;
import ru.rutoken.security.Cleanable;
import ru.rutoken.tools.Platform;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class Context
implements AlgorithmParameterSpec,
Cleanable {
    protected final PKCS11 p11;
    protected final Config config;

    public Context() throws P11Exception {
        this(null);
    }

    public Context(Config config) throws P11Exception {
        String string;
        this.config = config;
        String string2 = string = config == null ? Config.getDefaultLibrary() : config.getLibrary();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid config. PKCS#11 library not found.");
        }
        try {
            this.p11 = Context.openLib(string);
        }
        catch (Exception exception) {
            throw new P11Exception(exception.toString(), exception);
        }
    }

    public static PKCS11 openLib(String string) throws Exception {
        Object object;
        int n = Platform.getJavaVersion();
        if (n < 5) {
            throw new ProviderException();
        }
        if (n == 5) {
            Class[] classArray = new Class[]{String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE};
            Method method = PKCS11.class.getMethod("getInstance", classArray);
            Object[] objectArray = new Object[]{string, new CK_C_INITIALIZE_ARGS(), false};
            object = method.invoke(PKCS11.class, objectArray);
        } else {
            Class[] classArray = new Class[]{String.class, String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE};
            Method method = PKCS11.class.getMethod("getInstance", classArray);
            Object[] objectArray = new Object[]{string, "C_GetFunctionList", new CK_C_INITIALIZE_ARGS(), false};
            object = method.invoke(PKCS11.class, objectArray);
        }
        return (PKCS11)object;
    }

    public void close() throws P11Exception {
        try {
            this.p11.C_Finalize(null);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    protected PKCS11 get() {
        return this.p11;
    }

    public Config getConfig() {
        return this.config;
    }

    public ContextInfo getInfo() throws P11Exception {
        try {
            CK_INFO cK_INFO = this.p11.C_GetInfo();
            return new ContextInfo(cK_INFO);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public long[] getSlotList() throws P11Exception {
        try {
            return this.p11.C_GetSlotList(true);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public SlotInfo getSlotInfo(long l) throws P11Exception {
        try {
            CK_SLOT_INFO cK_SLOT_INFO = this.p11.C_GetSlotInfo(l);
            return new SlotInfo(cK_SLOT_INFO);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public Token getToken() throws P11Exception {
        Token token = null;
        try {
            Object object;
            long[] lArray = this.p11.C_GetSlotList(true);
            if (lArray.length == 0) {
                throw new P11Exception("No token found.");
            }
            if (this.config == null || this.config.getSerial() == null) {
                token = new Token(this, lArray[0]);
            } else {
                object = lArray;
                int n = ((long[])object).length;
                for (int i = 0; i < n; ++i) {
                    String string;
                    long l = object[i];
                    token = new Token(this, l);
                    String string2 = this.config.getSerial();
                    if (string2.equals(string = token.getSerial())) break;
                    token = null;
                }
            }
            if (token != null && (object = this.config != null ? (Object)this.config.getPin() : (Object)Config.getDefaultPin()) != null) {
                token.setPin(((String)object).toCharArray());
            }
            return token;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public Token getFirstToken() throws P11Exception {
        try {
            long[] lArray = this.p11.C_GetSlotList(true);
            if (lArray.length == 0) {
                throw new P11Exception("No token found.");
            }
            return new Token(this, lArray[0]);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public Token getToken(long l) throws P11Exception {
        return new Token(this, l);
    }

    public void clean() {
        this.config.clean();
    }
}

