/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.level11;

import java.lang.reflect.Method;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.jrt11.SessionFactory;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Const11;
import ru.rutoken.jrt11.level11.Context;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.SessionInfo;
import ru.rutoken.jrt11.level11.Token;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.Cleanable;
import ru.rutoken.tools.Platform;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class Session
implements Const11,
AlgorithmParameterSpec,
Cleanable {
    public static final long INVALID_HANDLE = -1L;
    protected final PKCS11 p11;
    protected final Context context;
    protected final Token token;
    protected long session = -1L;
    protected boolean loggedIn = false;

    public Session(Token token, char[] cArray) throws P11Exception {
        this.token = token;
        this.context = this.token.getContext();
        this.p11 = this.context.get();
        this.open(cArray);
    }

    protected void finalize() throws Throwable {
        if (this.session != -1L) {
            this.p11.C_CloseSession(this.session);
            this.session = -1L;
        }
        super.finalize();
    }

    public Context getContext() {
        return this.context;
    }

    public Token getToken() {
        return this.token;
    }

    protected long getHandle() {
        return this.session;
    }

    public void open() throws P11Exception {
        this.open(null, 6L);
    }

    public void open(char[] cArray) throws P11Exception {
        this.open(cArray, 6L);
    }

    public void open(char[] cArray, long l) throws P11Exception {
        try {
            this.session = this.p11.C_OpenSession(this.token.getSlot(), l, null, null);
            SessionFactory.addSession(this);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
        if (cArray != null) {
            this.login(cArray);
        }
    }

    public void close() throws P11Exception {
        try {
            if (this.session != -1L) {
                this.logout();
                this.p11.C_CloseSession(this.session);
                this.session = -1L;
                SessionFactory.removeSession(this);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public boolean isOpened() {
        return this.session != -1L;
    }

    public void login(char[] cArray) throws P11Exception {
        block3: {
            try {
                if (!this.loggedIn) {
                    this.p11.C_Login(this.session, 1L, cArray);
                    this.loggedIn = true;
                }
            }
            catch (PKCS11Exception pKCS11Exception) {
                if (pKCS11Exception.getErrorCode() == 256L) break block3;
                throw new P11Exception(pKCS11Exception);
            }
        }
    }

    public void logout() throws P11Exception {
        try {
            if (this.loggedIn) {
                this.p11.C_Logout(this.session);
                this.loggedIn = false;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public SessionInfo getSessionInfo() throws P11Exception {
        try {
            CK_SESSION_INFO cK_SESSION_INFO = this.p11.C_GetSessionInfo(this.session);
            return new SessionInfo(cK_SESSION_INFO);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public TokenObj[] findObjects(AttributeList attributeList) throws P11Exception {
        TokenObj[] tokenObjArray;
        try {
            this.p11.C_FindObjectsInit(this.session, attributeList.list);
            long[] lArray = this.p11.C_FindObjects(this.session, 1024L);
            this.p11.C_FindObjectsFinal(this.session);
            tokenObjArray = new TokenObj[lArray.length];
            for (int i = 0; i < tokenObjArray.length; ++i) {
                tokenObjArray[i] = new TokenObj(this, lArray[i]);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
        return tokenObjArray;
    }

    public TokenObj createObject(AttributeList attributeList) throws P11Exception {
        try {
            long l = this.p11.C_CreateObject(this.session, attributeList.list);
            return new TokenObj(this, l);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public void randomGenerate(byte[] byArray) throws P11Exception {
        try {
            this.p11.C_GenerateRandom(this.session, byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public void digestReset(Mechanism mechanism) throws P11Exception {
        try {
            this.p11.C_DigestInit(this.session, mechanism.get());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public void digestUpdate(byte[] byArray, int n, int n2) throws P11Exception {
        try {
            this.p11.C_DigestUpdate(this.session, 0L, byArray, n, n2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public byte[] digestDigest(byte[] byArray) throws P11Exception {
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.p11.C_DigestFinal(this.session, byArray, 0, byArray.length);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
        return byArray;
    }

    public byte[] digestSingle(Mechanism mechanism, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws P11Exception {
        try {
            this.p11.C_DigestSingle(this.session, mechanism.get(), byArray, n, n2, byArray2, n3, n4);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
        return byArray2;
    }

    public TokenObj[] genKeyPair(Mechanism mechanism, AttributeList attributeList, AttributeList attributeList2) throws P11Exception {
        try {
            long[] lArray = this.p11.C_GenerateKeyPair(this.session, mechanism.get(), attributeList.list, attributeList2.list);
            return new TokenObj[]{new TokenObj(this, lArray[0]), new TokenObj(this, lArray[1])};
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public TokenObj generateSecret(Mechanism mechanism, AttributeList attributeList) throws P11Exception {
        try {
            long l = this.p11.C_GenerateKey(this.session, mechanism.get(), attributeList.list);
            return new TokenObj(this, l);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public TokenObj deriveKey(TokenObj tokenObj, Mechanism mechanism, AttributeList attributeList) throws P11Exception {
        try {
            long l = this.p11.C_DeriveKey(this.session, mechanism.get(), tokenObj.getHandle(), attributeList.list);
            return new TokenObj(this, l);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public void macInit(TokenObj tokenObj, Mechanism mechanism) throws P11Exception {
        try {
            this.p11.C_SignInit(this.session, mechanism.get(), tokenObj.getHandle());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public void macUpdate(byte[] byArray, int n, int n2) throws P11Exception {
        try {
            this.p11.C_SignUpdate(this.session, 0L, byArray, n, n2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public byte[] macFinal(int n) throws P11Exception {
        try {
            int n2 = Platform.getJavaVersion();
            if (n2 == 5) {
                Class[] classArray = new Class[]{Long.TYPE};
                Object[] objectArray = new Object[]{this.session};
                Method method = this.p11.getClass().getMethod("C_SignFinal", classArray);
                return (byte[])method.invoke((Object)this.p11, objectArray);
            }
            Class[] classArray = new Class[]{Long.TYPE, Integer.TYPE};
            Object[] objectArray = new Object[]{this.session, n};
            Method method = this.p11.getClass().getMethod("C_SignFinal", classArray);
            return (byte[])method.invoke((Object)this.p11, objectArray);
        }
        catch (Exception exception) {
            throw new P11Exception(exception.toString(), exception);
        }
    }

    public byte[] macSingle(byte[] byArray) throws P11Exception {
        try {
            return this.p11.C_Sign(this.session, byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public TokenObj copyObject(TokenObj tokenObj, AttributeList attributeList) throws P11Exception {
        try {
            long l = this.p11.C_CopyObject(this.session, tokenObj.getHandle(), attributeList.list);
            return new TokenObj(this, l);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public void encryptInit(TokenObj tokenObj, Mechanism mechanism) throws P11Exception {
        try {
            this.p11.C_EncryptInit(this.session, mechanism.get(), tokenObj.getHandle());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public int encryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws P11Exception {
        try {
            return this.p11.C_EncryptUpdate(this.session, 0L, byArray, n, n2, 0L, byArray2, n3, n4);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public int encryptFinal(byte[] byArray, int n, int n2) throws P11Exception {
        try {
            return this.p11.C_EncryptFinal(this.session, 0L, byArray, n, n2);
        }
        catch (Exception exception) {
            throw new P11Exception(exception.toString(), exception);
        }
    }

    public int encryptSingle(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws P11Exception {
        try {
            return this.p11.C_Encrypt(this.session, byArray, n, n2, byArray2, n3, n4);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public void decryptInit(TokenObj tokenObj, Mechanism mechanism) throws P11Exception {
        try {
            this.p11.C_DecryptInit(this.session, mechanism.get(), tokenObj.getHandle());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public int decryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws P11Exception {
        try {
            return this.p11.C_DecryptUpdate(this.session, 0L, byArray, n, n2, 0L, byArray2, n3, n4);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public int decryptFinal(byte[] byArray, int n, int n2) throws P11Exception {
        try {
            return this.p11.C_DecryptFinal(this.session, 0L, byArray, n, n2);
        }
        catch (Exception exception) {
            throw new P11Exception(exception.toString(), exception);
        }
    }

    public int decryptSingle(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws P11Exception {
        try {
            return this.p11.C_Decrypt(this.session, byArray, n, n2, byArray2, n3, n4);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public byte[] wrap(Mechanism mechanism, TokenObj tokenObj, TokenObj tokenObj2) throws P11Exception {
        try {
            return this.p11.C_WrapKey(this.session, mechanism.get(), tokenObj.getHandle(), tokenObj2.getHandle());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public TokenObj unwrap(Mechanism mechanism, TokenObj tokenObj, byte[] byArray, AttributeList attributeList) throws P11Exception {
        try {
            long l = this.p11.C_UnwrapKey(this.session, mechanism.get(), tokenObj.getHandle(), byArray, attributeList.list);
            return new TokenObj(this, l);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public void clean() {
        try {
            this.close();
        }
        catch (P11Exception p11Exception) {
            // empty catch block
        }
    }
}

