/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.level11;

import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.jrt11.level11.Attribute;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Const11;
import ru.rutoken.jrt11.level11.Context;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.jrt11.level11.SlotInfo;
import ru.rutoken.jrt11.level11.TokenInfo;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.Cleanable;
import ru.rutoken.tools.Arrays;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class Token
implements Const11,
AlgorithmParameterSpec,
Cleanable {
    protected final PKCS11 p11;
    protected final Context context;
    protected final long slot;
    protected char[] pin = null;
    public static final AttributeList DEBUG_ATTRIBUTES = new AttributeList(new Attribute[]{Attribute.CLASS_PRIVATE_KEY, Attribute.TOKEN_TRUE, Attribute.PRIVATE_TRUE, Attribute.ID_EMPTY, Attribute.LABEL_EMPTY});

    public Token(Context context, long l) throws P11Exception {
        this.context = context;
        this.slot = l;
        this.p11 = this.context.get();
    }

    public Context getContext() {
        return this.context;
    }

    public long getSlot() {
        return this.slot;
    }

    public void setPin(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            for (int i = 0; i < this.pin.length; ++i) {
                this.pin[i] = '\u0000';
            }
            this.pin = null;
        } else {
            int n = cArray.length;
            this.pin = new char[n];
            System.arraycopy(cArray, 0, this.pin, 0, n);
        }
    }

    public void cleanPin() {
        for (int i = 0; i < this.pin.length; ++i) {
            this.pin[i] = '\u0000';
        }
        this.pin = null;
    }

    public SlotInfo getSlotInfo() throws P11Exception {
        try {
            CK_SLOT_INFO cK_SLOT_INFO = this.p11.C_GetSlotInfo(this.slot);
            return new SlotInfo(cK_SLOT_INFO);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public TokenInfo getTokenInfo() throws P11Exception {
        try {
            CK_TOKEN_INFO cK_TOKEN_INFO = this.p11.C_GetTokenInfo(this.slot);
            return new TokenInfo(cK_TOKEN_INFO);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public String getLabel() throws P11Exception {
        try {
            CK_TOKEN_INFO cK_TOKEN_INFO = this.p11.C_GetTokenInfo(this.slot);
            return new String(cK_TOKEN_INFO.label);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public String getSerial() throws P11Exception {
        try {
            CK_TOKEN_INFO cK_TOKEN_INFO = this.p11.C_GetTokenInfo(this.slot);
            return new String(cK_TOKEN_INFO.serialNumber);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public Mechanism[] getMechanismList() throws P11Exception {
        try {
            long[] lArray = this.p11.C_GetMechanismList(this.slot);
            Mechanism[] mechanismArray = new Mechanism[lArray.length];
            for (int i = 0; i < mechanismArray.length; ++i) {
                mechanismArray[i] = new Mechanism(lArray[i]);
            }
            return mechanismArray;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public Session createSession() throws P11Exception {
        return new Session(this, this.pin);
    }

    public Session createSession(char[] cArray) throws P11Exception {
        return new Session(this, cArray);
    }

    public void deleteAll() throws P11Exception {
        TokenObj[] tokenObjArray;
        Session session = new Session(this, this.pin);
        for (TokenObj tokenObj : tokenObjArray = session.findObjects(AttributeList.ANY_ATTRIBUTE)) {
            try {
                tokenObj.delete();
            }
            catch (P11Exception p11Exception) {
                // empty catch block
            }
        }
    }

    public void checkTokenEmpty() throws P11Exception {
        Session session = new Session(this, this.pin);
        TokenObj[] tokenObjArray = session.findObjects(AttributeList.ANY_ATTRIBUTE);
        if (tokenObjArray.length != 0) {
            this.traceToken();
            throw new ProviderException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceToken() throws P11Exception {
        AttributeList attributeList = new AttributeList(AttributeList.ANY_ATTRIBUTE);
        Session session = null;
        try {
            session = new Session(this, this.pin);
            TokenObj[] tokenObjArray = session.findObjects(attributeList);
            for (int i = 0; i < tokenObjArray.length; ++i) {
                AttributeList attributeList2 = new AttributeList(DEBUG_ATTRIBUTES);
                TokenObj tokenObj = tokenObjArray[i];
                attributeList2 = tokenObj.getAttributes(attributeList2);
                System.out.println(tokenObj.toString());
                System.out.println(attributeList2.toString());
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public void clean() {
        Arrays.clean(this.pin);
    }
}

