/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.DigestInterface;

public class DigestSpi
extends MessageDigest
implements Cleanable {
    protected final DigestInterface implementation;

    public DigestSpi(DigestInterface digestInterface) {
        super(digestInterface.getAlgorithmName());
        this.implementation = digestInterface;
    }

    public void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.implementation.update(byArray, 0, 1);
    }

    public void engineUpdate(byte[] byArray, int n, int n2) {
        if (byArray == Cleaner.cleanByteArray) {
            Cleaner.clean(this);
        } else {
            this.implementation.update(byArray, n, n2);
        }
    }

    public byte[] engineDigest() {
        byte[] byArray = new byte[this.implementation.getDigestLength()];
        this.implementation.doFinal(byArray, 0);
        return byArray;
    }

    public void engineReset() {
        this.implementation.reset();
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.implementation.setParameter(algorithmParameterSpec);
    }

    public AlgorithmParameterSpec getParameter() {
        return this.implementation.getParameter();
    }

    public void clean() {
        Cleaner.clean(this.implementation);
    }
}

