/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.jrt11.impl.DigestWrapper;
import ru.rutoken.jrt11.impl.GostDigest11;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.DigestInterface;
import ru.rutoken.security.spec.gost.DigestParamFactory;
import ru.rutoken.tools.Arrays;

public class MessageDigest
implements Cleanable {
    public static final char SEPARATOR = '/';
    public static final String STR_SEPARATOR = "/";
    protected final DigestInterface implementation;
    private byte[] tempArray;

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        Object object;
        String string2 = null;
        if (string.indexOf(47) != -1) {
            object = string.split(STR_SEPARATOR);
            string = object[0];
            string2 = object[1];
        }
        object = "rtGOST3411".equalsIgnoreCase(string) ? new GostDigest11() : new DigestWrapper(string);
        if (string2 != null) {
            try {
                object.setParameter(DigestParamFactory.getInstance(string2));
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException(invalidAlgorithmParameterException);
            }
        }
        return new MessageDigest((DigestInterface)object);
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(string);
    }

    public static MessageDigest getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(string);
    }

    public MessageDigest(DigestInterface digestInterface) {
        this.implementation = digestInterface;
    }

    public String getAlgorithm() {
        return this.implementation.getAlgorithmName();
    }

    public Provider getProvider() {
        return null;
    }

    public int getDigestLength() {
        return this.implementation.getDigestLength();
    }

    public void clean() {
        Cleaner.clean(this.implementation);
        if (this.tempArray != null) {
            Arrays.clean(this.tempArray);
            this.tempArray = null;
        }
    }

    public void reset() {
        this.implementation.reset();
    }

    public AlgorithmParameterSpec getParameter() {
        return this.implementation.getParameter();
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.implementation.setParameter(algorithmParameterSpec);
    }

    public long getProcessedLength() {
        return this.implementation.getProcessedLength();
    }

    public void update(byte by) {
        byte[] byArray = new byte[]{by};
        this.implementation.update(byArray, 0, 1);
    }

    public void update(byte[] byArray) {
        this.implementation.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.implementation.update(byArray, n, n2);
    }

    public void update(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset();
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            this.implementation.update(byArray, n + n2, n3 - n2);
            byteBuffer.position(n3);
        } else {
            int n = byteBuffer.remaining();
            int n4 = Arrays.getTempArraySize(n);
            if (this.tempArray == null || n4 > this.tempArray.length) {
                this.tempArray = new byte[n4];
            }
            while (n > 0) {
                int n5 = Math.min(n, this.tempArray.length);
                byteBuffer.get(this.tempArray, 0, n5);
                this.implementation.update(this.tempArray, 0, n5);
                n -= n5;
            }
        }
    }

    public byte[] digest() {
        byte[] byArray = new byte[this.implementation.getDigestLength()];
        this.implementation.doFinal(byArray, 0);
        return byArray;
    }

    public byte[] digest(byte[] byArray) {
        this.implementation.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[this.implementation.getDigestLength()];
        this.implementation.doFinal(byArray2, 0);
        return byArray2;
    }

    public int digest(byte[] byArray, int n, int n2) {
        int n3 = this.implementation.getDigestLength();
        if (byArray == null || n3 < n2 || byArray.length - n < n3) {
            throw new IllegalArgumentException();
        }
        this.implementation.doFinal(byArray, n);
        return n3;
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n |= byArray[i] ^ byArray2[i];
        }
        return n == 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return new MessageDigest((DigestInterface)this.implementation.clone());
    }

    public String toString() {
        return this.implementation.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] digestBuffer(String string, byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string);
            if (algorithmParameterSpec != null) {
                try {
                    messageDigest.setParameter(algorithmParameterSpec);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new NoSuchAlgorithmException();
                }
            }
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
        finally {
            Cleaner.clean(messageDigest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] digestBuffer(String string, byte[] byArray, int n, int n2, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string);
            if (algorithmParameterSpec != null) {
                try {
                    messageDigest.setParameter(algorithmParameterSpec);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new NoSuchAlgorithmException();
                }
            }
            messageDigest.update(byArray, n, n2);
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
        finally {
            Cleaner.clean(messageDigest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] digestFile(String string, File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string);
            FileInputStream fileInputStream = null;
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[4096];
                for (long i = file.length(); i > 0L; i -= (long)n) {
                    n = i < (long)byArray.length ? (int)i : byArray.length;
                    n = fileInputStream.read(byArray, 0, n);
                    messageDigest.update(byArray, 0, n);
                }
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            Cleaner.clean(messageDigest);
        }
    }
}

