/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.PairGeneratorInterface;
import ru.rutoken.security.spec.ParamKeySize;

public class PairGeneratorSpi
extends KeyPairGenerator
implements Cleanable {
    protected final PairGeneratorInterface implementation;

    public PairGeneratorSpi(PairGeneratorInterface pairGeneratorInterface) {
        super(pairGeneratorInterface.getAlgorithmName());
        this.implementation = pairGeneratorInterface;
    }

    public void initialize(int n, SecureRandom secureRandom) {
        try {
            this.implementation.setParameter(new ParamKeySize(n));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == Cleaner.ParamClean.INSTANCE) {
            Cleaner.clean(this);
        } else {
            this.implementation.setParameter(algorithmParameterSpec);
        }
    }

    public KeyPair generateKeyPair() {
        return this.implementation.generateKeyPair();
    }

    public void clean() {
        Cleaner.clean(this.implementation);
    }
}

