/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.MessageDigest;
import ru.rutoken.security.PrivateKeyInterface;
import ru.rutoken.security.PublicKeyInterface;
import ru.rutoken.security.SecureRandom;
import ru.rutoken.security.SpecPrivateKey;
import ru.rutoken.security.SpecPublicKey;
import ru.rutoken.tools.Arrays;

public class Signature
implements Cleanable {
    protected SpecPrivateKey privateKey = null;
    protected SpecPublicKey publicKey = null;
    public final String algorithm;
    public final String keyAlgorithm;
    public final String digestAlgorithm;
    protected final MessageDigest messageDigest;

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        return new Signature(string);
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException {
        return new Signature(string);
    }

    public static Signature getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        return new Signature(string);
    }

    public Signature(String string) throws NoSuchAlgorithmException {
        int n = string.indexOf("with");
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        this.algorithm = string;
        this.keyAlgorithm = string.substring(n + 4);
        this.digestAlgorithm = string.substring(0, n);
        this.messageDigest = MessageDigest.getInstance(this.digestAlgorithm);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Provider getProvider() {
        return null;
    }

    protected int getSignatureLength() {
        return this.privateKey != null ? this.privateKey.getImpl().getSignatureLength() : (this.publicKey != null ? this.publicKey.getImpl().getSignatureLength() : 0);
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.privateKey = null;
        if (!(publicKey instanceof SpecPublicKey)) {
            throw new InvalidKeyException();
        }
        this.publicKey = (SpecPublicKey)publicKey;
        if (!this.keyAlgorithm.equals(publicKey.getAlgorithm())) {
            throw new InvalidKeyException();
        }
        this.messageDigest.reset();
    }

    public void initVerify(Certificate certificate) throws InvalidKeyException {
        this.initVerify(certificate.getPublicKey());
    }

    public void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.publicKey = null;
        if (!(privateKey instanceof SpecPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (SpecPrivateKey)privateKey;
        if (!this.keyAlgorithm.equals(privateKey.getAlgorithm())) {
            throw new InvalidKeyException();
        }
        this.messageDigest.reset();
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.initSign(privateKey);
    }

    public void update(byte by) throws SignatureException {
        if (this.privateKey == null && this.publicKey == null) {
            throw new SignatureException();
        }
        this.messageDigest.update(by);
    }

    public void update(byte[] byArray) throws SignatureException {
        if (this.privateKey == null && this.publicKey == null) {
            throw new SignatureException();
        }
        this.messageDigest.update(byArray);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.privateKey == null && this.publicKey == null) {
            throw new SignatureException();
        }
        this.messageDigest.update(byArray, n, n2);
    }

    public void update(ByteBuffer byteBuffer) throws SignatureException {
        if (this.privateKey == null && this.publicKey == null) {
            throw new SignatureException();
        }
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset();
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            this.messageDigest.update(byArray, n + n2, n3 - n2);
            byteBuffer.position(n3);
        } else {
            int n;
            int n4;
            byte[] byArray = new byte[Arrays.getTempArraySize(n4)];
            for (n4 = byteBuffer.remaining(); n4 > 0; n4 -= n) {
                n = Math.min(n4, byArray.length);
                byteBuffer.get(byArray, 0, n);
                this.messageDigest.update(byArray, 0, n);
            }
        }
    }

    public byte[] sign() throws SignatureException {
        byte[] byArray;
        if (this.privateKey == null) {
            throw new SignatureException("Signature was not initialized properly.");
        }
        byte[] byArray2 = this.messageDigest.digest();
        PrivateKeyInterface privateKeyInterface = this.privateKey.getImpl();
        try {
            byArray = privateKeyInterface.signature(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        return byArray;
    }

    public int sign(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2;
        if (this.privateKey == null) {
            throw new SignatureException("Signature was not initialized properly.");
        }
        PrivateKeyInterface privateKeyInterface = this.privateKey.getImpl();
        if (byArray == null) {
            throw new IllegalArgumentException("No output buffer given");
        }
        if (byArray.length - n < n2 || n2 < privateKeyInterface.getSignatureLength()) {
            throw new IllegalArgumentException("Output buffer too small for specified offset and length");
        }
        byte[] byArray3 = this.messageDigest.digest();
        try {
            byArray2 = privateKeyInterface.signature(byArray3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        if (this.publicKey == null) {
            throw new SignatureException("Signature was not initialized properly.");
        }
        byte[] byArray2 = this.messageDigest.digest();
        PublicKeyInterface publicKeyInterface = this.publicKey.getImpl();
        boolean bl = publicKeyInterface.verifySignature(byArray, byArray2);
        return bl;
    }

    public boolean verify(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return this.verify(byArray2);
    }

    public String toString() {
        return this.algorithm;
    }

    @Deprecated
    public void setParameter(String string, Object object) throws InvalidParameterException {
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
    }

    public AlgorithmParameters getParameters() {
        return null;
    }

    @Deprecated
    public Object getParameter(String string) throws InvalidParameterException {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void clean() {
        this.privateKey = null;
        this.publicKey = null;
        Cleaner.clean(this.messageDigest);
    }
}

