/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security.spec.gost;

import ru.rutoken.security.spec.OID;
import ru.rutoken.security.spec.gost.DigestParamInterface;

public class DigestParamSpec
implements DigestParamInterface {
    public static final String STR_TEST = "1.2.643.2.2.30.0";
    public static final String STR_CRYPTOPRO_A = "1.2.643.2.2.30.1";
    public static final String STR_CRYPTOPRO_B = "1.2.643.2.2.30.2";
    public static final String STR_CRYPTOPRO_C = "1.2.643.2.2.30.3";
    public static final String STR_CRYPTOPRO_D = "1.2.643.2.2.30.4";
    public static final byte[] ENCODED_TEST = new byte[]{6, 7, 42, -123, 3, 2, 2, 30, 0};
    public static final byte[] ENCODED_CRYPTOPRO_A = new byte[]{6, 7, 42, -123, 3, 2, 2, 30, 1};
    public static final byte[] ENCODED_CRYPTOPRO_B = new byte[]{6, 7, 42, -123, 3, 2, 2, 30, 2};
    public static final byte[] ENCODED_CRYPTOPRO_C = new byte[]{6, 7, 42, -123, 3, 2, 2, 30, 3};
    public static final byte[] ENCODED_CRYPTOPRO_D = new byte[]{6, 7, 42, -123, 3, 2, 2, 30, 4};
    public static final OID[] OID_LIST = new OID[]{new OID("1.2.643.2.2.30.0"), new OID("1.2.643.2.2.30.1"), new OID("1.2.643.2.2.30.2"), new OID("1.2.643.2.2.30.3"), new OID("1.2.643.2.2.30.4")};
    public static final String[] STRING_LIST = new String[]{"1.2.643.2.2.30.0", "1.2.643.2.2.30.1", "1.2.643.2.2.30.2", "1.2.643.2.2.30.3", "1.2.643.2.2.30.4"};
    public static final byte[][] ENCODED_LIST = new byte[][]{ENCODED_TEST, ENCODED_CRYPTOPRO_A, ENCODED_CRYPTOPRO_B, ENCODED_CRYPTOPRO_C, ENCODED_CRYPTOPRO_D};
    public static final int[] DEFAULT_START_VECTOR = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected final int index;

    public DigestParamSpec(int n) {
        if (n < 0 || n > OID_LIST.length) {
            throw new IllegalArgumentException();
        }
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public void setStartHash(int[] nArray) {
        System.arraycopy(DEFAULT_START_VECTOR, 0, nArray, 0, DEFAULT_START_VECTOR.length);
    }

    public byte[] getSubstitution() {
        return null;
    }

    public int[] getKMT() {
        return null;
    }

    public OID getOID() {
        return OID_LIST[this.index];
    }

    public byte[] getEncodedOID() {
        return ENCODED_LIST[this.index];
    }

    public String toString() {
        return STRING_LIST[this.index];
    }

    public boolean equals(Object object) {
        return object instanceof DigestParamSpec && this.index == ((DigestParamSpec)object).index;
    }

    public int hashCode() {
        return this.index;
    }
}

