/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
* В данном файле содержится объявление следующих вспомогательных         *
* функций для работы с Рутокен при помощи программы Cert2Cont:           *
*  - получения массива имен криптопровайдеров;                           *
*  - выбора криптопровайдера для дальнейшей работы.                      *
*************************************************************************/


#ifndef _CSPS_H
#define _CSPS_H


/************************************************************************
* Получить массив имен криптопровайдеров                                *
************************************************************************/
BOOL EnumCSPs(OUT LPWSTR lpszCSPs[],      // Массив указателей на строки с именами криптопровайдеров
              OUT DWORD pdwCSPsTypes[],   // Массив типов криптопровайдеров
              OUT DWORD* pdwCSPsCount     // Количество элементов в массивах
              );


/************************************************************************
* Получить порядковый номер элемента в массиве имен криптопровайдеров,  *
* для которого имя криптопровайдера из массива совпадает с именем       *
* криптопровайдера, переданным пользователем                            *
************************************************************************/
DWORD SelectCSP(IN LPCWSTR lpszPreferredCSP,   // Указатель на строку с именем криптопровайдера, переданным пользователем
                IN LPWSTR lpszCSPs[],          // Массив указателей на строки с именами криптопровайдеров
                IN DWORD pdwCSPsTypes[],       // Массив типов криптопровайдеров
                IN DWORD dwCSPsCount           // Количество элементов в массивах
                );

#endif        // _CSPS_H
