/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

package ru.rutoken.samples;

public final class Constants {
    public static final byte[] ATTR_CRYPTO_PRO_A = {0x06, 0x07, 0x2A, (byte) 0x85, 0x03, 0x02, 0x02, 0x23, 0x01};
    public static final byte[] ATTR_CRYPTO_PRO_A_512 = {0x06, 0x09, 0x2A, (byte) 0x85, 0x03, 0x07, 0x01, 0x02, 0x01, 0x02, 0x01};

    public final static byte[] ATTR_HASH_2012_256 = {0x06, 0x08, 0x2a, (byte) 0x85, 0x03, 0x07, 0x01, 0x01, 0x02, 0x02};
    public final static byte[] ATTR_HASH_2012_512 = {0x06, 0x08, 0x2a, (byte) 0x85, 0x03, 0x07, 0x01, 0x01, 0x02, 0x03};

    public static final byte[] DEFAULT_USER_PIN = {'1', '2', '3', '4', '5', '6', '7', '8'};
    public static final byte[] DEFAULT_SO_PIN = {'8', '7', '6', '5', '4', '3', '2', '1'};

    public static final byte[] RECIPIENT_KEY = {
            (byte) 0x76, (byte) 0x25, (byte) 0x13, (byte) 0x0F, (byte) 0x19, (byte) 0x17, (byte) 0x3D, (byte) 0x3B, (byte) 0x24, (byte) 0xCC, (byte) 0xA7, (byte) 0xC7, (byte) 0x72, (byte) 0xB3, (byte) 0x5D, (byte) 0x83,
            (byte) 0xB0, (byte) 0xBB, (byte) 0x42, (byte) 0xC9, (byte) 0x66, (byte) 0xD5, (byte) 0xC1, (byte) 0x5A, (byte) 0x0A, (byte) 0x9F, (byte) 0xD4, (byte) 0x24, (byte) 0xF0, (byte) 0x46, (byte) 0xB2, (byte) 0xCD,
            (byte) 0x85, (byte) 0xDD, (byte) 0xC5, (byte) 0x73, (byte) 0xAE, (byte) 0x72, (byte) 0x8D, (byte) 0x6F, (byte) 0xC8, (byte) 0x9C, (byte) 0xE2, (byte) 0x5B, (byte) 0x89, (byte) 0x05, (byte) 0xE8, (byte) 0x9D,
            (byte) 0x75, (byte) 0x93, (byte) 0xBF, (byte) 0xE9, (byte) 0x38, (byte) 0xC3, (byte) 0x43, (byte) 0x27, (byte) 0x09, (byte) 0x59, (byte) 0x7E, (byte) 0x7D, (byte) 0x51, (byte) 0xA8, (byte) 0x35, (byte) 0x53
    };

    public static final byte[] RECIPIENT_KEY_512 = {
            (byte) 0xFC, (byte) 0xD5, (byte) 0xD3, (byte) 0x91, (byte) 0xEF, (byte) 0x58, (byte) 0x66, (byte) 0x50, (byte) 0x26, (byte) 0x59, (byte) 0x6C, (byte) 0x71, (byte) 0xE5, (byte) 0x89, (byte) 0x35, (byte) 0xC7,
            (byte) 0x35, (byte) 0x71, (byte) 0x28, (byte) 0xA4, (byte) 0xAD, (byte) 0x3C, (byte) 0xD5, (byte) 0x0A, (byte) 0xA3, (byte) 0xF8, (byte) 0xB1, (byte) 0xD9, (byte) 0xC1, (byte) 0x77, (byte) 0xB3, (byte) 0x17,
            (byte) 0x65, (byte) 0x0C, (byte) 0x7E, (byte) 0x6E, (byte) 0x11, (byte) 0x12, (byte) 0xC2, (byte) 0x62, (byte) 0xB3, (byte) 0xDF, (byte) 0x43, (byte) 0x32, (byte) 0x54, (byte) 0xB4, (byte) 0x7C, (byte) 0x7D,
            (byte) 0xF3, (byte) 0x3C, (byte) 0x1F, (byte) 0xD7, (byte) 0xEA, (byte) 0x02, (byte) 0xE7, (byte) 0x70, (byte) 0x15, (byte) 0xCC, (byte) 0xFC, (byte) 0x28, (byte) 0xC6, (byte) 0xAE, (byte) 0x91, (byte) 0x29,
            (byte) 0x58, (byte) 0xFB, (byte) 0x75, (byte) 0x14, (byte) 0x7B, (byte) 0x0E, (byte) 0x99, (byte) 0x59, (byte) 0xF9, (byte) 0x4B, (byte) 0xE9, (byte) 0x80, (byte) 0xA5, (byte) 0xBB, (byte) 0x18, (byte) 0x8E,
            (byte) 0xED, (byte) 0x43, (byte) 0xCC, (byte) 0x8D, (byte) 0x9E, (byte) 0x39, (byte) 0x14, (byte) 0x6A, (byte) 0xBA, (byte) 0xC7, (byte) 0x5F, (byte) 0xFF, (byte) 0x02, (byte) 0x4C, (byte) 0x1C, (byte) 0x9E,
            (byte) 0xFE, (byte) 0x71, (byte) 0xF2, (byte) 0xC3, (byte) 0xFD, (byte) 0xD6, (byte) 0x1C, (byte) 0x76, (byte) 0xBE, (byte) 0xCF, (byte) 0x77, (byte) 0xB6, (byte) 0xD7, (byte) 0x5D, (byte) 0xFF, (byte) 0x35,
            (byte) 0x3C, (byte) 0x35, (byte) 0x70, (byte) 0x78, (byte) 0x03, (byte) 0xED, (byte) 0x6E, (byte) 0x0A, (byte) 0x03, (byte) 0x65, (byte) 0xDC, (byte) 0xA4, (byte) 0xAA, (byte) 0x59, (byte) 0x8B, (byte) 0xDB
    };

    public static final byte[] MESSAGE = {
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07};

    public static final byte[] MESSAGE_512 = {
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07};

    // Список полей DN (Distinguished Name)
    public final static String[] DN = {
            "CN",
            "Ivanoff",
            "C",
            "RU",
            "2.5.4.5",
            "12312312312",
            "1.2.840.113549.1.9.1",
            "ivanov@mail.ru",
            "ST",
            "Moscow",
    };

    // Список дополнительных полей
    public final static String[] EXTS = {
            "keyUsage",
            "digitalSignature,nonRepudiation,keyEncipherment,dataEncipherment",
            "extendedKeyUsage",
            "1.2.643.2.2.34.6,1.3.6.1.5.5.7.3.2,1.3.6.1.5.5.7.3.4",
    };

    private Constants() {
    }
}
