package ru.rutoken.samples.pkcs11Wrapper;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.ptr.NativeLongByReference;
import ru.rutoken.pkcs11jna.CK_RUTOKEN_INIT_PARAM;
import ru.rutoken.pkcs11jna.CK_TOKEN_INFO_EXTENDED;
import ru.rutoken.pkcs11jna.Pkcs11Constants;
import ru.rutoken.pkcs11jna.RtPkcs11Constants;
import ru.rutoken.samples.Constants;

public class ExtendedFunctions {
    private final static byte[] NEW_PIN = {'1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private final static String TOKEN_LABEL = "It is my Rutoken label sample ";
    private final static String TOKEN_LONG_LABEL = "!!!Sample of Rutoken long-long-long-long-long label!!!";
    private final static int MAX_ADMIN_RETRY_COUNT = 10;
    private final static int MAX_USER_RETRY_COUNT = 10;

    public static void main(String[] args) {
        NativeLong hSession = new NativeLong(Pkcs11Constants.CK_INVALID_HANDLE);
        try {
            System.out.println("Example of rtpkcs11ecp extended functions usage via JNA");

            System.out.println("Library initialization and acquiring of function list");
            NativeLong rv = RtPkcs11Library.getPkcs11Interface().C_Initialize(null);
            Pkcs11Exception.throwIfNotOk("C_Initialize failed", rv);

            System.out.println("Acquiring list of slots with connected tokens");
            NativeLongByReference slotsCount = new NativeLongByReference();
            rv = RtPkcs11Library.getPkcs11Interface().C_GetSlotList(Pkcs11Constants.CK_TRUE, null, slotsCount);
            Pkcs11Exception.throwIfNotOk("C_GetSlotList failed", rv);
            if (slotsCount.getValue().intValue() == 0) {
                throw new Exception("No Rutoken is available!");
            }
            NativeLong[] pSlotList = new NativeLong[slotsCount.getValue().intValue()];
            rv = RtPkcs11Library.getPkcs11Interface().C_GetSlotList(Pkcs11Constants.CK_TRUE, pSlotList, slotsCount);
            Pkcs11Exception.throwIfNotOk("C_GetSlotList failed", rv);

            System.out.println("Acquiring token extended info");
            CK_TOKEN_INFO_EXTENDED tokenInfoEx = new CK_TOKEN_INFO_EXTENDED();
            tokenInfoEx.ulSizeofThisStructure = new NativeLong(tokenInfoEx.size());
            rv = RtPkcs11Library.getPkcs11ExtendedInterface().C_EX_GetTokenInfoExtended(pSlotList[0], tokenInfoEx);
            Pkcs11Exception.throwIfNotOk("C_EX_GetTokenInfoExtended failed", rv);

            System.out.println("Token info:");
            System.out.printf(" Token type: \t\t\t\t0x%08X ", tokenInfoEx.ulTokenType.longValue());
            if (tokenInfoEx.ulTokenType.longValue() == RtPkcs11Constants.TOKEN_TYPE_RUTOKEN_ECP)
                System.out.println("(Rutoken ECP)");
            if (tokenInfoEx.ulTokenType.longValue() == RtPkcs11Constants.TOKEN_TYPE_RUTOKEN_LITE)
                System.out.println("(Rutoken Lite)");
            if (tokenInfoEx.ulTokenType.longValue() == RtPkcs11Constants.TOKEN_TYPE_RUTOKEN)
                System.out.println("(Rutoken)");
            System.out.printf(" Protocol number: \t\t\t0x%08X \n", tokenInfoEx.ulProtocolNumber.longValue());
            System.out.printf(" Microcode number:  \t\t0x%08X \n", tokenInfoEx.ulMicrocodeNumber.longValue());
            System.out.printf(" Flags: \t\t\t\t\t0x%08X\n", tokenInfoEx.flags.longValue());
            System.out.printf(" Min Admin PIN length: \t\t0x%08X \n", tokenInfoEx.ulMinAdminPinLen.longValue());
            System.out.printf(" Max User PIN length: \t\t0x%08X\n", tokenInfoEx.ulMaxUserPinLen.longValue());
            System.out.printf(" Min User PIN length: \t\t0x%08X\n", tokenInfoEx.ulMinUserPinLen.longValue());
            System.out.printf(" Max Admin login failures: \t0x%08X \n", tokenInfoEx.ulMaxAdminRetryCount.longValue());
            System.out.printf(" Admin login failures: \t\t0x%08X \n", tokenInfoEx.ulAdminRetryCountLeft.longValue());
            System.out.printf(" Max User login failures: \t0x%08X \n", tokenInfoEx.ulMaxUserRetryCount.longValue());
            System.out.printf(" User login failures: \t\t0x%08X \n", tokenInfoEx.ulUserRetryCountLeft.longValue());
            System.out.printf(" Token SN: \t\t\t\t\t0x");
            for (int i = 4; i < tokenInfoEx.serialNumber.length; ++i)
                System.out.printf("%02X", tokenInfoEx.serialNumber[i]);
            System.out.println();
            System.out.printf(" Total memory: \t\t\t\t0x%08X\n", tokenInfoEx.ulTotalMemory.longValue());
            System.out.printf(" Free  memory: \t\t\t\t0x%08X\n", tokenInfoEx.ulFreeMemory.longValue());
            System.out.printf(" ATR: \t\t\t\t\t\t");
            for (int i = 0; i < tokenInfoEx.ulATRLen.longValue(); ++i)
                System.out.printf("%02X", tokenInfoEx.ATR[i]);

            System.out.println("\nToken initialization");
            CK_RUTOKEN_INIT_PARAM initInfo = new CK_RUTOKEN_INIT_PARAM();
            initInfo.UseRepairMode = new NativeLong(0);
            initInfo.pNewAdminPin = new Memory(Constants.DEFAULT_SO_PIN.length);
            initInfo.pNewAdminPin.write(0, Constants.DEFAULT_SO_PIN, 0, Constants.DEFAULT_SO_PIN.length);
            initInfo.ulNewAdminPinLen = new NativeLong(Constants.DEFAULT_SO_PIN.length);
            initInfo.pNewUserPin = new Memory(NEW_PIN.length);
            initInfo.pNewUserPin.write(0, NEW_PIN, 0, NEW_PIN.length);
            initInfo.ulNewUserPinLen = new NativeLong(NEW_PIN.length);
            initInfo.ulMinAdminPinLen = new NativeLong(6);
            initInfo.ulMinUserPinLen = new NativeLong(6);
            initInfo.ChangeUserPINPolicy = new NativeLong(RtPkcs11Constants.TOKEN_FLAGS_ADMIN_CHANGE_USER_PIN |
                    RtPkcs11Constants.TOKEN_FLAGS_USER_CHANGE_USER_PIN);
            initInfo.ulMaxAdminRetryCount = new NativeLong(MAX_ADMIN_RETRY_COUNT);
            initInfo.ulMaxUserRetryCount = new NativeLong(MAX_USER_RETRY_COUNT);
            initInfo.pTokenLabel = new Memory(TOKEN_LABEL.length());
            initInfo.pTokenLabel.write(0, TOKEN_LABEL.getBytes(), 0, TOKEN_LABEL.length());
            initInfo.ulLabelLen = new NativeLong(TOKEN_LABEL.length());
            initInfo.ulSmMode = new NativeLong(0);
            initInfo.ulSizeofThisStructure = new NativeLong(initInfo.size());

            rv = RtPkcs11Library.getPkcs11ExtendedInterface().C_EX_InitToken(pSlotList[0], Constants.DEFAULT_SO_PIN, new NativeLong(Constants.DEFAULT_SO_PIN.length), initInfo);
            Pkcs11Exception.throwIfNotOk("C_EX_InitToken failed", rv);

            System.out.println("Opening session");
            NativeLongByReference phSession = new NativeLongByReference();
            rv = RtPkcs11Library.getPkcs11Interface().C_OpenSession(pSlotList[0],
                    new NativeLong(Pkcs11Constants.CKF_SERIAL_SESSION |
                            Pkcs11Constants.CKF_RW_SESSION),
                    null, null, phSession);
            Pkcs11Exception.throwIfNotOk("C_OpenSession failed", rv);
            hSession = phSession.getValue();

            System.out.println("Logging in as administrator");
            rv = RtPkcs11Library.getPkcs11Interface().C_Login(hSession, new NativeLong(Pkcs11Constants.CKU_SO), Constants.DEFAULT_SO_PIN, new NativeLong(Constants.DEFAULT_SO_PIN.length));
            Pkcs11Exception.throwIfNotOk("C_Login failed", rv);

            System.out.println("User PIN unlocking");
            rv = RtPkcs11Library.getPkcs11ExtendedInterface().C_EX_UnblockUserPIN(hSession);
            Pkcs11Exception.throwIfNotOk("C_EX_UnblockUserPIN failed", rv);

            System.out.println("Logging out");
            rv = RtPkcs11Library.getPkcs11Interface().C_Logout(hSession);
            Pkcs11Exception.throwIfNotOk("C_Logout failed", rv);

            System.out.println("Logging in as user");
            rv = RtPkcs11Library.getPkcs11Interface().C_Login(hSession, new NativeLong(Pkcs11Constants.CKU_USER),
                    NEW_PIN, new NativeLong(NEW_PIN.length));
            Pkcs11Exception.throwIfNotOk("C_Login failed", rv);

            System.out.println("Setting token name");
            rv = RtPkcs11Library.getPkcs11ExtendedInterface().C_EX_SetTokenName(hSession, TOKEN_LONG_LABEL.getBytes(),
                    new NativeLong(TOKEN_LONG_LABEL.length()));
            Pkcs11Exception.throwIfNotOk("C_EX_SetTokenName failed", rv);

            System.out.println("User PIN changing");
            rv = RtPkcs11Library.getPkcs11Interface().C_SetPIN(hSession, NEW_PIN, new NativeLong(NEW_PIN.length),
                    Constants.DEFAULT_USER_PIN, new NativeLong(Constants.DEFAULT_USER_PIN.length));
            Pkcs11Exception.throwIfNotOk("C_SetPIN failed", rv);
        } catch (Exception e) {
            System.out.println(e.getMessage());
        } finally {
            System.out.println("Logging out");
            NativeLong rv = RtPkcs11Library.getPkcs11Interface().C_Logout(hSession);
            Util.checkIfNotOk("C_Logout failed", rv.longValue());

            System.out.println("Closing session");
            rv = RtPkcs11Library.getPkcs11Interface().C_CloseSession(hSession);
            Util.checkIfNotOk("C_CloseSession failed", rv.longValue());

            System.out.println("Finalizing PKCS11 library");
            rv = RtPkcs11Library.getPkcs11Interface().C_Finalize(null);
            Util.checkIfNotOk("C_Finalize failed", rv.longValue());

            System.out.println("Test has been completed.");
        }
    }
}

