package ru.rutoken.samples.pkcs11Wrapper;

import com.sun.jna.NativeLong;
import com.sun.jna.ptr.NativeLongByReference;
import ru.rutoken.pkcs11jna.Pkcs11Constants;
import ru.rutoken.samples.Constants;

public class Init {
    private final static byte[] TOKEN_LABEL = {'M', 'y', ' ', 'R', 'u', 't', 'o', 'k',
            'e', 'n', ' ', ' ', ' ', ' ', ' ', ' ',
            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};

    public static void main(String[] args) {
        NativeLong hSession = new NativeLong(Pkcs11Constants.CK_INVALID_HANDLE);
        try {
            System.out.println("Example of token initialization using rtpkcs11ecp via JNA");

            System.out.println("Library initialization and acquiring of function list");
            NativeLong rv = RtPkcs11Library.getPkcs11Interface().C_Initialize(null);
            Pkcs11Exception.throwIfNotOk("C_Initialize failed", rv);

            System.out.println("Acquiring list of slots with connected tokens");

            NativeLongByReference slotsCount = new NativeLongByReference();
            rv = RtPkcs11Library.getPkcs11Interface().C_GetSlotList(Pkcs11Constants.CK_TRUE, null, slotsCount);
            Pkcs11Exception.throwIfNotOk("C_GetSlotList failed", rv);
            if (slotsCount.getValue().intValue() == 0) {
                throw new Exception("No Rutoken is available!");
            }

            NativeLong[] pSlotList = new NativeLong[slotsCount.getValue().intValue()];
            rv = RtPkcs11Library.getPkcs11Interface().C_GetSlotList(Pkcs11Constants.CK_TRUE, pSlotList, slotsCount);
            Pkcs11Exception.throwIfNotOk("C_GetSlotList failed", rv);

            System.out.println("Token initialization");
            rv = RtPkcs11Library.getPkcs11Interface().C_InitToken(pSlotList[0], Constants.DEFAULT_SO_PIN, new NativeLong(Constants.DEFAULT_SO_PIN.length), TOKEN_LABEL);
            Pkcs11Exception.throwIfNotOk("C_InitToken failed", rv);

            System.out.println("Opening session");
            NativeLongByReference phSession = new NativeLongByReference();
            rv = RtPkcs11Library.getPkcs11Interface().C_OpenSession(pSlotList[0],
                    new NativeLong(Pkcs11Constants.CKF_SERIAL_SESSION | Pkcs11Constants.CKF_RW_SESSION),
                    null, null, phSession);
            Pkcs11Exception.throwIfNotOk("C_OpenSession failed", rv);
            hSession = phSession.getValue();

            System.out.println("Logging in as administrator");
            rv = RtPkcs11Library.getPkcs11Interface().C_Login(hSession, new NativeLong(Pkcs11Constants.CKU_SO), Constants.DEFAULT_SO_PIN, new NativeLong(Constants.DEFAULT_SO_PIN.length));
            Pkcs11Exception.throwIfNotOk("C_Login failed", rv);

            System.out.println("User PIN initialization");
            rv = RtPkcs11Library.getPkcs11Interface().C_InitPIN(hSession, Constants.DEFAULT_USER_PIN, new NativeLong(Constants.DEFAULT_USER_PIN.length));
            Pkcs11Exception.throwIfNotOk("C_InitPIN failed", rv);
        } catch (Exception e) {
            System.out.println(e.getMessage());
        } finally {
            System.out.println("Logging out");
            NativeLong rv = RtPkcs11Library.getPkcs11Interface().C_Logout(hSession);
            Util.checkIfNotOk("C_Logout failed", rv.longValue());

            System.out.println("Closing session");
            rv = RtPkcs11Library.getPkcs11Interface().C_CloseSession(hSession);
            Util.checkIfNotOk("C_CloseSession failed", rv.longValue());

            System.out.println("Finalizing PKCS11 library");
            rv = RtPkcs11Library.getPkcs11Interface().C_Finalize(null);
            Util.checkIfNotOk("C_Finalize failed", rv.longValue());

            System.out.println("Test has been completed.");
        }
    }
}
