/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

package ru.rutoken.samples.pkcs11Wrapper;

import com.sun.jna.NativeLong;
import ru.rutoken.pkcs11jna.Pkcs11Constants;

public class Pkcs11Exception extends Exception {

    private Pkcs11Exception(String message) {
        super(message);
    }

    public static void throwIfNotOk(String message, NativeLong code) throws Pkcs11Exception {
        if (code.longValue() != Pkcs11Constants.CKR_OK)
            throw new Pkcs11Exception(message + ", error code: " + Long.toHexString(code.longValue()));
    }
}
