/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

package ru.rutoken.samples.pkcs11Wrapper;

import com.sun.jna.Native;
import ru.rutoken.pkcs11jna.Pkcs11;
import ru.rutoken.pkcs11jna.RtPkcs11;

class RtPkcs11Library {
    private static final RtPkcs11 INSTANCE = load();

    public static Pkcs11 getPkcs11Interface() {
        return INSTANCE;
    }

    public static RtPkcs11 getPkcs11ExtendedInterface() {
        return INSTANCE;
    }

    private static RtPkcs11 load() {
        try {
            return Native.loadLibrary(Native.extractFromResourcePath("rtpkcs11ecp").getAbsolutePath(), RtPkcs11.class);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
