/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

package ru.rutoken.samples.pkcs11Wrapper;

import com.sun.jna.Memory;
import ru.rutoken.pkcs11jna.Pkcs11Constants;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Base64;
import java.util.Scanner;

class Util {
    static String readCert() {
        String kMatchHeader = ".*-----BEGIN[^-]*(-[^-]+)*-----";
        String kMatchFooter = "-----END[^-]*(-[^-]+)*-----.*";

        Scanner in = new Scanner(System.in);

        String currentLine = in.nextLine();
        StringBuilder cert = new StringBuilder();
        do {
            cert.append(currentLine);
            currentLine = in.nextLine();
        } while (!currentLine.isEmpty());

        return cert.toString().replaceFirst(kMatchHeader, "").replaceFirst(kMatchFooter, "");
    }

    static void printCsr(final byte[] csrDer) {
        final int lineWidth = 64;
        // Encode from der to base64
        String csrBase64 = Base64.getEncoder().encodeToString(csrDer);
        int k = 0;
        while (k < csrBase64.length() / lineWidth) {
            System.out.println(csrBase64.substring(k * lineWidth, (k + 1) * lineWidth));
            k++;
        }
        System.out.println(csrBase64.substring(k * lineWidth, csrBase64.length()));
    }

    static void checkIfNotOk(String function, long rv) {
        if (rv != Pkcs11Constants.CKR_OK)
            System.out.println(function + ", error code: " + Long.toHexString(rv));
    }

    static Memory allocateDeriveParamsGOSTR3410_2012(int kdf, byte[] key, byte[] ukm) {
        ByteBuffer s = ByteBuffer.allocate(3 * Integer.BYTES + key.length * Byte.BYTES + ukm.length * Byte.BYTES);
        s.order(ByteOrder.LITTLE_ENDIAN);
        s.putInt(kdf);
        s.putInt(key.length);
        s.put(key);
        s.putInt(ukm.length);
        s.put(ukm);

        Memory p = new Memory(s.capacity());
        p.write(0, s.array(), 0, s.capacity());

        return p;
    }
}
