/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

package ru.rutoken.samples.sunPkcs11Wrapper;

import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

class Util {
    static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0x0F];
        }
        return new String(hexChars);
    }

    static long[] findObject(PKCS11 pkcs11Wrapper, long session, CK_ATTRIBUTE[] template) throws PKCS11Exception {
        long[] foundObjects;
        pkcs11Wrapper.C_FindObjectsInit(session, template);
        foundObjects = pkcs11Wrapper.C_FindObjects(session, 100);
        pkcs11Wrapper.C_FindObjectsFinal(session);
        System.out.println("Search has been completed. Objects found: " + foundObjects.length);
        return foundObjects;
    }

    static byte[] hashData(PKCS11 pkcs11Wrapper, long session, long mechanism, byte[] message) throws PKCS11Exception {
        System.out.println("Data hashing");

        byte[] digestedMessage = new byte[message.length];

        /*
        В данной операции используется аппаратное хэширование. Для использования программного хэширования
        необходимо в качестве второго аргумента передать
        new CK_MECHANISM(RtPkcs11Constants.CKM_GOSTR3411.longValue(), ATTR_CRYPTO_PRO_A)
        */

        pkcs11Wrapper.C_DigestSingle(session, new CK_MECHANISM(mechanism),
                message, 0, message.length, digestedMessage, 0, digestedMessage.length);

        System.out.println("Hashed data:");
        for (int i = 0; i < digestedMessage.length; ++i) {
            System.out.printf(" %02X", digestedMessage[i]);
            if ((i + 1) % 8 == 0)
                System.out.println();
        }
        System.out.println("Hashing has been completed.");
        return digestedMessage;
    }
}
