/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

//  Copyright (c) 2013 Aktiv Co. All rights reserved.
#ifndef pcsc_android_keystore_h
#define pcsc_android_keystore_h

#include <stddef.h>

#ifdef KEYSTORAGE_USE_OWN_RETURN_CODES
#define RUTOKEN_ERROR_INVALID_APPID						0x8FEF
#define RUTOKEN_ERROR_NO_SUCH_KEY						0x8FEE
#define RUTOKEN_ERROR_UNEXPECTED						0x8FF1 /* неизвестное исключение C++ */
#define RUTOKEN_ERROR_INSUFFICIENT_MEMORY				0x8FF4 /* недостаточно памяти */
#define RUTOKEN_ERROR_INVALID_PARAMETER					0x8FFD
#ifndef ERROR_SUCCESS
#define ERROR_SUCCESS									0L
#endif // ERROR_SUCCESS
#else
#include <SM_Error.h>
#endif // KEYSTORAGE_USE_OWN_RETURN_CODES

#ifdef __cplusplus
extern "C"
{
#endif

int saveKey(const char* mszPublicKey, size_t cchPublicKeyLen, const char* mszKeyString, size_t cchKeyStringLen);

int readKey(const char* mszPublicKey, size_t cchPublicKeyLen, char* mszKeyString, size_t* pcchKeyStringLen);

#ifdef __cplusplus
}
#endif

#endif // pcsc_android_keystore_h
