/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

/*
 * Aktiv Co. <hotline@rutoken.ru>
 *
 */

package ru.rutoken.pkcs11smsample;


import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import android.text.InputType;
import android.view.View;
import android.widget.EditText;

import java.nio.charset.Charset;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);
    }

    private AlertDialog createSmInputPasswordDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("SM password");

        final EditText input = new EditText(this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        builder.setView(input);

        builder.setPositiveButton("OK", (dialog, which) -> {
            byte[] password = input.getText().toString().getBytes(Charset.forName("US-ASCII"));
            onStartSmOkButtonClick(password);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        return builder.create();
    }

    public void onGetInfoClick(View view) {
        Intent intent = new Intent(MainActivity.this, Pkcs11SampleActivity.class);
        intent.putExtra("sampleType", Pkcs11SampleActivity.SampleType.GET_TOKEN_INFO);
        startActivity(intent);
    }

    public void onHashDataButtonClick(View view) {
        Intent intent = new Intent(MainActivity.this, Pkcs11SampleActivity.class);
        intent.putExtra("sampleType", Pkcs11SampleActivity.SampleType.HASH_DATA);
        startActivity(intent);
    }

    public void onStartSmButtonClick(View view) {
        createSmInputPasswordDialog().show();
    }

    private void onStartSmOkButtonClick(byte[] password) {
        Intent intent = new Intent(MainActivity.this, Pkcs11SampleActivity.class);
        intent.putExtra("sampleType", Pkcs11SampleActivity.SampleType.START_SM);
        intent.putExtra("password", password);
        startActivity(intent);
    }
}
