#import "CPReader.h"

@implementation CPReader
{
	NSString* _nickname;
	NSString* _name;
	NSString* _media;
	uint8_t _flags;
}

- (CPReader*)initWithData: (uint8_t*)dataPtr {
	self = [super init];
	if (self) {
		_nickname = [[NSString alloc] initWithBytes:dataPtr length:strlen((char*)dataPtr) encoding:NSUTF8StringEncoding];
		dataPtr += 1 + [_nickname length];
		_name = [[NSString alloc] initWithBytes:dataPtr length:strlen((char*)dataPtr) encoding:NSUTF8StringEncoding];
		dataPtr += 1 + [_name length];
		_media = [[NSString alloc] initWithBytes:dataPtr length:strlen((char*)dataPtr) encoding:NSUTF8StringEncoding];
		dataPtr += 1 + [_name length];
		_flags = *dataPtr;
	}
	
	return self;
}

- (ReaderStatus)getReaderStatus {
	NSArray* invalidStrings = [[NSArray alloc] initWithObjects:@"NO_UNIQUE", @"INVALID_MEDIA", @"IS_FKC", @"NO_FKC", nil];
	NSString* noMediaString = @"NO_MEDIA";
	
	for (NSString* str in invalidStrings) {
		if ([_media rangeOfString:str].location != NSNotFound) {
			return kErrorReader;
		}
	}
	
	if ([_media rangeOfString:noMediaString].location != NSNotFound) {
		return kNoMediaReader;
	}
	
	return kValidReader;
}

- (bool)isRutoken {
	return [_name rangeOfString:@"Rutoken ECP BT"].location != NSNotFound;
}

- (NSComparisonResult)localizedCaseInsensitiveCompare:(CPReader *)reader {
	return [_name localizedCaseInsensitiveCompare:[reader name]];
}
@end
