/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

#ifndef common_h
#define common_h

#import <Foundation/Foundation.h>

@interface DataLogger : NSObject
+ (void)logData:(NSString*)data;
@end

#define THROW_ERROR(...) @throw[NSException exceptionWithName : @ "a" \
	                            reason : @ "a" \
	                            userInfo : nil]; \

#define CHECK_AND_LOG(msg, expression, errMsg) \
	do { \
		[self logData :[NSString stringWithFormat : @ "%s", msg]]; \
		if (!(expression)) { \
			[self logData :[NSString stringWithFormat : @ " -> Failed\n%s\n", errMsg]]; \
			@throw[NSException exceptionWithName :[NSString stringWithFormat : @ "%s", msg] \
			       reason :[NSString stringWithFormat : @ "%s", errMsg] \
			       userInfo : nil]; \
		} \
		else { \
			[self logData : @ " -> OK\n"]; \
		} \
	} while (0)

#define LOG(msg) [self logData :[NSString stringWithFormat : @ "%s", msg]]

#endif // common_h
