/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

/*! \file mutex.h
 *  \brief Заголовочный файл с описанием структур и функций для управления мьютексами.
 */

#ifndef RUTOKEN_ENGINE_MUTEX_H
#define RUTOKEN_ENGINE_MUTEX_H

#include "call.h"


#ifdef __cplusplus
extern "C" {
#endif


typedef struct rt_eng_mutex_vtable_st rt_eng_mutex_vtable;

/*! \brief Структура для хранения мьютекса и его функций. */
typedef struct {
/*! Указатель на таблицу функций. */
    const rt_eng_mutex_vtable *vtable;
/*! Указатель на мьютекс. */
    void *self;
} rt_eng_mutex;

/*! \brief Таблица функций мьютекса. */
struct rt_eng_mutex_vtable_st {
/*! \brief Функция освобождения памяти для мьютекса. */
    void (*free)(rt_eng_mutex *that);
/*! \brief Функция блокирования мьютекса.
 *  \return 1 в случае успеха, 0 в случае ошибки.
 */
    int (*lock)(rt_eng_mutex *that);
/*! \brief Функция освобождения мьютекса.
 *  \return 1 в случае успеха, 0 в случае ошибки.
 */
    int (*unlock)(rt_eng_mutex *that);
};

/*! \brief Функция создания мьютекса.
 *  При успешном выполнении заполняет все поля структуры.
 *  \return 1 в случае успеха, 0 в случае ошибки.
 */
typedef rt_eng_mutex (*rt_eng_mutex_new_t)(void);


#ifdef __cplusplus
}
#endif

#endif // RUTOKEN_ENGINE_MUTEX_H
