/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

/*! \file base.h
 *  \brief В данном файле описаны прототипы функций для управления rtengine.
 */

#ifndef RUTOKEN_ENGINE_BASE_H
#define RUTOKEN_ENGINE_BASE_H

#include <openssl/engine.h>

#ifdef __cplusplus
extern "C" {
#endif


/*! \brief Создание rtengine и регистрация его в OpenSSL.
 *  \return 1 в случае успеха, 0 в случае ошибки.
 */
int rt_eng_init(void);

/*! \brief Завершение rtengine и его последующее удаление из OpenSSL.
 *  \return 1 в случае успеха, 0 в случае ошибки.
 */
int rt_eng_final(void);

/*! \brief Получение экземпляра rtengine.
 *  \return описатель rtengine случае успеха, NULL в случае ошибки.
 */
ENGINE *rt_eng_get0_engine(void);


#ifdef __cplusplus
}
#endif

#endif // RUTOKEN_ENGINE_BASE_H
