/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

/*! \file call.h
 * \brief Заголовочный файл с макросами для вызова методов объекта.
 *
 * <div class="memitem">
 *   <div class="memproto">
 *     <table class="memname">
 *       <tr>
 *         <td class="memname">RT_ENG_CALL </td>
 *         <td>(</td>
 *         <td class="paramname">OBJECT</td>
 *         <td>, </td>
 *         <td class="paramname">METHOD</td>
 *         <td>, </td>
 *         <td class="paramname">...</td>
 *         <td>)</td>
 *       </tr>
 *     </table>
 *   </div>
 *   <div class="memdoc">
 *     <dl class="section">
 *       <dt>RT_ENG_CALL</dt>
 *       <dd>Макрос принимает на вход объект, метод, который будет вызван у объекта и аргументы для этого метода.</dd>
 *       <dt>Пример использования:</dt>
 *       <dd>RT_ENG_CALL(wrappedSession, free);</dd>
 *     </dl>
 *   </div>
 * </div>
 */

#ifndef RUTOKEN_ENGINE_CALL_H
#define RUTOKEN_ENGINE_CALL_H

#ifdef _WIN32

#define RT_ENG_CALL(OBJECT, METHOD, ...) \
    (OBJECT).vtable->METHOD(&(OBJECT), __VA_ARGS__)

#else

#define RT_ENG_CALL(...) \
    RT_ENG_DETAIL_CALL(__VA_ARGS__)

#define RT_ENG_DETAIL_CALL(OBJECT, METHOD, ...) \
    (OBJECT).vtable->METHOD(&(OBJECT), ##__VA_ARGS__)

#endif


#endif // RUTOKEN_ENGINE_CALL_H
