/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

/*! \file err.h
 *  \brief Заголовочный файл с кодами ошибок.
 *  Ошибки генерируются автоматически с помощью скрипта mkerr.pl.
 */
/*
 * Copyright 1995-2017 The OpenSSL Project Authors. All Rights Reserved.
 *
 * Licensed under the OpenSSL license (the "License").  You may not use
 * this file except in compliance with the License.  You can obtain a copy
 * in the file LICENSE in the source distribution or at
 * https://www.openssl.org/source/license.html
 */
#ifndef HEADER_RTENG_ERR_H
# define HEADER_RTENG_ERR_H

# ifdef  __cplusplus
extern "C" {
# endif

/*! \brief Возвращает код библиотеки закрепленный за rtengine в OpenSSL.
 *  \return код rtengine.
 */

/* BEGIN ERROR CODES */
/*
 * The following lines are auto generated by the script mkerr.pl. Any changes
 * made after this point may be overwritten when the script is next run.
 */

int ERR_RTENG_library_code(void);

/* Error codes for the RTENG functions. */

/* Function codes. */
# define RTENG_F_DECODE_HEX                               100
# define RTENG_F_EC_KEY_DERIVE                            101
# define RTENG_F_ENGINE_BIND                              102
# define RTENG_F_ENGINE_CREATE                            103
# define RTENG_F_FILL_DECRYPT_CEK_DATA                    104
# define RTENG_F_FIND_TOKEN_CALLBACK                      105
# define RTENG_F_FOR_EACH_TOKEN                           106
# define RTENG_F_GET0_EC_KEY                              107
# define RTENG_F_HANDLE_CTRL                              108
# define RTENG_F_INIT_ALGORITHM_NID                       109
# define RTENG_F_INIT_PARAMSET_NID                        110
# define RTENG_F_LOAD_KEY                                 111
# define RTENG_F_MATCH_TOKEN_CALLBACK                     112
# define RTENG_F_NEW_GOST_DECRYPT_CEK_DATA                113
# define RTENG_F_PARSE                                    114
# define RTENG_F_PARSE_CALLBACK                           115
# define RTENG_F_PARSE_PATTR                              116
# define RTENG_F_PUBLIC_KEY_TO_BUF                        117
# define RTENG_F_RAND_BYTES                               118
# define RTENG_F_RAND_INIT                                119
# define RTENG_F_RT_ENG_DECRYPT                           120
# define RTENG_F_RT_ENG_DL_CLOSE                          121
# define RTENG_F_RT_ENG_DL_OPEN                           122
# define RTENG_F_RT_ENG_DL_SYM                            123
# define RTENG_F_RT_ENG_EC_KEY_DECRYPT_CEK                124
# define RTENG_F_RT_ENG_FINAL                             125
# define RTENG_F_RT_ENG_GET0_EC_KEY                       126
# define RTENG_F_RT_ENG_HARD_EC_KEY_DERIVE                127
# define RTENG_F_RT_ENG_INVALIDATE_P11_EVP_PKEY           128
# define RTENG_F_RT_ENG_NEW_P11_EVP_PKEY                  129
# define RTENG_F_RT_ENG_P11_DEALER_DERIVE                 130
# define RTENG_F_RT_ENG_P11_DEALER_SIGN                   131
# define RTENG_F_RT_ENG_P11_SESS_CANCEL_FUNCTION          132
# define RTENG_F_RT_ENG_P11_SESS_COPY_OBJECT              133
# define RTENG_F_RT_ENG_P11_SESS_CREATE_OBJECT            134
# define RTENG_F_RT_ENG_P11_SESS_DECRYPT                  135
# define RTENG_F_RT_ENG_P11_SESS_DECRYPT_DIGEST_UPDATE    136
# define RTENG_F_RT_ENG_P11_SESS_DECRYPT_FINAL            137
# define RTENG_F_RT_ENG_P11_SESS_DECRYPT_INIT             138
# define RTENG_F_RT_ENG_P11_SESS_DECRYPT_UPDATE           139
# define RTENG_F_RT_ENG_P11_SESS_DECRYPT_VERIFY_UPDATE    140
# define RTENG_F_RT_ENG_P11_SESS_DERIVE_KEY               141
# define RTENG_F_RT_ENG_P11_SESS_DESTROY_OBJECT           142
# define RTENG_F_RT_ENG_P11_SESS_DIGEST                   143
# define RTENG_F_RT_ENG_P11_SESS_DIGEST_ENCRYPT_UPDATE    144
# define RTENG_F_RT_ENG_P11_SESS_DIGEST_FINAL             145
# define RTENG_F_RT_ENG_P11_SESS_DIGEST_INIT              146
# define RTENG_F_RT_ENG_P11_SESS_DIGEST_KEY               147
# define RTENG_F_RT_ENG_P11_SESS_DIGEST_UPDATE            148
# define RTENG_F_RT_ENG_P11_SESS_ENCRYPT                  149
# define RTENG_F_RT_ENG_P11_SESS_ENCRYPT_FINAL            150
# define RTENG_F_RT_ENG_P11_SESS_ENCRYPT_INIT             151
# define RTENG_F_RT_ENG_P11_SESS_ENCRYPT_UPDATE           152
# define RTENG_F_RT_ENG_P11_SESS_FIND_OBJECTS             153
# define RTENG_F_RT_ENG_P11_SESS_FIND_OBJECTS_FINAL       154
# define RTENG_F_RT_ENG_P11_SESS_FIND_OBJECTS_INIT        155
# define RTENG_F_RT_ENG_P11_SESS_GENERATE_KEY             156
# define RTENG_F_RT_ENG_P11_SESS_GENERATE_KEY_PAIR        157
# define RTENG_F_RT_ENG_P11_SESS_GENERATE_RANDOM          158
# define RTENG_F_RT_ENG_P11_SESS_GET_ATTRIBUTE_VALUE      159
# define RTENG_F_RT_ENG_P11_SESS_GET_FUNCTION_STATUS      160
# define RTENG_F_RT_ENG_P11_SESS_GET_OBJECT_SIZE          161
# define RTENG_F_RT_ENG_P11_SESS_GET_OPERATION_STATE      162
# define RTENG_F_RT_ENG_P11_SESS_GET_SESSION_INFO         163
# define RTENG_F_RT_ENG_P11_SESS_INIT                     164
# define RTENG_F_RT_ENG_P11_SESS_LOCK                     165
# define RTENG_F_RT_ENG_P11_SESS_LOGIN                    166
# define RTENG_F_RT_ENG_P11_SESS_LOGOUT                   167
# define RTENG_F_RT_ENG_P11_SESS_SEED_RANDOM              168
# define RTENG_F_RT_ENG_P11_SESS_SET_ATTRIBUTE_VALUE      169
# define RTENG_F_RT_ENG_P11_SESS_SET_OPERATION_STATE      170
# define RTENG_F_RT_ENG_P11_SESS_SIGN                     171
# define RTENG_F_RT_ENG_P11_SESS_SIGN_ENCRYPT_UPDATE      172
# define RTENG_F_RT_ENG_P11_SESS_SIGN_FINAL               173
# define RTENG_F_RT_ENG_P11_SESS_SIGN_INIT                174
# define RTENG_F_RT_ENG_P11_SESS_SIGN_RECOVER             175
# define RTENG_F_RT_ENG_P11_SESS_SIGN_RECOVER_INIT        176
# define RTENG_F_RT_ENG_P11_SESS_SIGN_UPDATE              177
# define RTENG_F_RT_ENG_P11_SESS_UNLOCK                   178
# define RTENG_F_RT_ENG_P11_SESS_UNWRAP_KEY               179
# define RTENG_F_RT_ENG_P11_SESS_VERIFY                   180
# define RTENG_F_RT_ENG_P11_SESS_VERIFY_FINAL             181
# define RTENG_F_RT_ENG_P11_SESS_VERIFY_INIT              182
# define RTENG_F_RT_ENG_P11_SESS_VERIFY_RECOVER           183
# define RTENG_F_RT_ENG_P11_SESS_VERIFY_RECOVER_INIT      184
# define RTENG_F_RT_ENG_P11_SESS_VERIFY_UPDATE            185
# define RTENG_F_RT_ENG_P11_SESS_WRAP_KEY                 186
# define RTENG_F_RT_ENG_SIGN                              187
# define RTENG_F_RT_ENG_SOFT_EC_KEY_SIGN                  188
# define RTENG_F_RT_ENG_STANDALONE_FIND_KEY               189
# define RTENG_F_RT_ENG_STANDALONE_FIND_TOKEN             190
# define RTENG_F_RT_ENG_STANDALONE_FINISH                 191
# define RTENG_F_RT_ENG_STANDALONE_INIT                   192
# define RTENG_F_RT_ENG_STANDALONE_SET_MODULE_PATH        193
# define RTENG_F_RT_ENG_STANDALONE_SET_RAND_TOKEN         194

/* Reason codes. */
# define RTENG_R_AMBIGUOUS_P11_URI                        100
# define RTENG_R_BUFFER_TOO_SMALL                         101
# define RTENG_R_CANNOT_CONVERT_BN                        102
# define RTENG_R_COULD_NOT_FIND_PRIVATE_KEY               103
# define RTENG_R_COULD_NOT_FIND_PUBLIC_KEY                104
# define RTENG_R_COULD_NOT_FIND_SYMBOL_IN_LIBRARY         105
# define RTENG_R_COULD_NOT_FIND_TOKEN                     106
# define RTENG_R_COULD_NOT_LOAD_LIBRARY                   107
# define RTENG_R_COULD_NOT_UNLOAD_LIBRARY                 108
# define RTENG_R_ECDH_EX_ERROR                            109
# define RTENG_R_ENGINE_HAS_BEEN_ALREADY_CREATED          110
# define RTENG_R_ENGINE_HAS_NOT_BEEN_INITIALIZED          111
# define RTENG_R_ENGINE_NOT_DEFAULT                       112
# define RTENG_R_ERROR_PARSING_KEY_TRANSPORT_INFO         113
# define RTENG_R_MUTEX_LOCK_FAILED                        114
# define RTENG_R_MUTEX_NEW_FAILED                         115
# define RTENG_R_MUTEX_UNLOCK_FAILED                      116
# define RTENG_R_NOT_IN_STANDALONE_MODE                   117
# define RTENG_R_NO_EC_GROUP                              118
# define RTENG_R_NO_EC_PARAMSET                           119
# define RTENG_R_NO_EC_PRIVATE_KEY                        120
# define RTENG_R_NO_PEER_KEY                              121
# define RTENG_R_NO_PUBLIC_KEY                            122
# define RTENG_R_PKCS11_ARGUMENTS_BAD                     123
# define RTENG_R_PKCS11_ATTRIBUTE_READ_ONLY               124
# define RTENG_R_PKCS11_ATTRIBUTE_SENSITIVE               125
# define RTENG_R_PKCS11_ATTRIBUTE_TYPE_INVALID            126
# define RTENG_R_PKCS11_ATTRIBUTE_VALUE_INVALID           127
# define RTENG_R_PKCS11_BUFFER_TOO_SMALL                  128
# define RTENG_R_PKCS11_CANCEL                            129
# define RTENG_R_PKCS11_CANT_LOCK                         130
# define RTENG_R_PKCS11_CRYPTOKI_ALREADY_INITIALIZED      131
# define RTENG_R_PKCS11_CRYPTOKI_NOT_INITIALIZED          132
# define RTENG_R_PKCS11_DATA_INVALID                      133
# define RTENG_R_PKCS11_DATA_LEN_RANGE                    134
# define RTENG_R_PKCS11_DEVICE_ERROR                      135
# define RTENG_R_PKCS11_DEVICE_MEMORY                     136
# define RTENG_R_PKCS11_DEVICE_REMOVED                    137
# define RTENG_R_PKCS11_DOMAIN_PARAMS_INVALID             138
# define RTENG_R_PKCS11_ENCRYPTED_DATA_INVALID            139
# define RTENG_R_PKCS11_ENCRYPTED_DATA_LEN_RANGE          140
# define RTENG_R_PKCS11_FUNCTION_CANCELED                 141
# define RTENG_R_PKCS11_FUNCTION_FAILED                   142
# define RTENG_R_PKCS11_FUNCTION_NOT_PARALLEL             143
# define RTENG_R_PKCS11_FUNCTION_NOT_SUPPORTED            144
# define RTENG_R_PKCS11_FUNCTION_REJECTED                 145
# define RTENG_R_PKCS11_GENERAL_ERROR                     146
# define RTENG_R_PKCS11_HOST_MEMORY                       147
# define RTENG_R_PKCS11_INFORMATION_SENSITIVE             148
# define RTENG_R_PKCS11_KEY_CHANGED                       149
# define RTENG_R_PKCS11_KEY_FUNCTION_NOT_PERMITTED        150
# define RTENG_R_PKCS11_KEY_HANDLE_INVALID                151
# define RTENG_R_PKCS11_KEY_INDIGESTIBLE                  152
# define RTENG_R_PKCS11_KEY_NEEDED                        153
# define RTENG_R_PKCS11_KEY_NOT_NEEDED                    154
# define RTENG_R_PKCS11_KEY_NOT_WRAPPABLE                 155
# define RTENG_R_PKCS11_KEY_SIZE_RANGE                    156
# define RTENG_R_PKCS11_KEY_TYPE_INCONSISTENT             157
# define RTENG_R_PKCS11_KEY_UNEXTRACTABLE                 158
# define RTENG_R_PKCS11_MECHANISM_INVALID                 159
# define RTENG_R_PKCS11_MECHANISM_PARAM_INVALID           160
# define RTENG_R_PKCS11_MUTEX_BAD                         161
# define RTENG_R_PKCS11_MUTEX_NOT_LOCKED                  162
# define RTENG_R_PKCS11_NEED_TO_CREATE_THREADS            163
# define RTENG_R_PKCS11_NEW_PIN_MODE                      164
# define RTENG_R_PKCS11_NEXT_OTP                          165
# define RTENG_R_PKCS11_NO_EVENT                          166
# define RTENG_R_PKCS11_OBJECT_HANDLE_INVALID             167
# define RTENG_R_PKCS11_OK                                168
# define RTENG_R_PKCS11_OPERATION_ACTIVE                  169
# define RTENG_R_PKCS11_OPERATION_NOT_INITIALIZED         170
# define RTENG_R_PKCS11_PIN_EXPIRED                       171
# define RTENG_R_PKCS11_PIN_INCORRECT                     172
# define RTENG_R_PKCS11_PIN_INVALID                       173
# define RTENG_R_PKCS11_PIN_LEN_RANGE                     174
# define RTENG_R_PKCS11_PIN_LOCKED                        175
# define RTENG_R_PKCS11_RANDOM_NO_RNG                     176
# define RTENG_R_PKCS11_RANDOM_SEED_NOT_SUPPORTED         177
# define RTENG_R_PKCS11_SAVED_STATE_INVALID               178
# define RTENG_R_PKCS11_SESSION_CLOSED                    179
# define RTENG_R_PKCS11_SESSION_COUNT                     180
# define RTENG_R_PKCS11_SESSION_EXISTS                    181
# define RTENG_R_PKCS11_SESSION_HANDLE_INVALID            182
# define RTENG_R_PKCS11_SESSION_PARALLEL_NOT_SUPPORTED    183
# define RTENG_R_PKCS11_SESSION_READ_ONLY                 184
# define RTENG_R_PKCS11_SESSION_READ_ONLY_EXISTS          185
# define RTENG_R_PKCS11_SESSION_READ_WRITE_SO_EXISTS      186
# define RTENG_R_PKCS11_SIGNATURE_INVALID                 187
# define RTENG_R_PKCS11_SIGNATURE_LEN_RANGE               188
# define RTENG_R_PKCS11_SLOT_ID_INVALID                   189
# define RTENG_R_PKCS11_STATE_UNSAVEABLE                  190
# define RTENG_R_PKCS11_TEMPLATE_INCOMPLETE               191
# define RTENG_R_PKCS11_TEMPLATE_INCONSISTENT             192
# define RTENG_R_PKCS11_TOKEN_NOT_PRESENT                 193
# define RTENG_R_PKCS11_TOKEN_NOT_RECOGNIZED              194
# define RTENG_R_PKCS11_TOKEN_WRITE_PROTECTED             195
# define RTENG_R_PKCS11_UNKNOWN_ERROR                     196
# define RTENG_R_PKCS11_UNWRAPPING_KEY_HANDLE_INVALID     197
# define RTENG_R_PKCS11_UNWRAPPING_KEY_SIZE_RANGE         198
# define RTENG_R_PKCS11_UNWRAPPING_KEY_TYPE_INCONSISTENT  199
# define RTENG_R_PKCS11_USER_ALREADY_LOGGED_IN            200
# define RTENG_R_PKCS11_USER_ANOTHER_ALREADY_LOGGED_IN    201
# define RTENG_R_PKCS11_USER_NOT_LOGGED_IN                202
# define RTENG_R_PKCS11_USER_PIN_NOT_INITIALIZED          203
# define RTENG_R_PKCS11_USER_TOO_MANY_TYPES               204
# define RTENG_R_PKCS11_USER_TYPE_INVALID                 205
# define RTENG_R_PKCS11_WRAPPED_KEY_INVALID               206
# define RTENG_R_PKCS11_WRAPPED_KEY_LEN_RANGE             207
# define RTENG_R_PKCS11_WRAPPING_KEY_HANDLE_INVALID       208
# define RTENG_R_PKCS11_WRAPPING_KEY_SIZE_RANGE           209
# define RTENG_R_PKCS11_WRAPPING_KEY_TYPE_INCONSISTENT    210
# define RTENG_R_REFERENCES_REMAINED                      211
# define RTENG_R_SESSION_NOT_SET                          212
# define RTENG_R_STORE_BIGNUM_ERROR                       213
# define RTENG_R_UNKNOWN_KEY_TYPE                         214
# define RTENG_R_UNKNOWN_OID                              215
# define RTENG_R_UNSUPPORTED_PATTR_TYPE                   216
# define RTENG_R_UNWRAP_ERROR                             217
# define RTENG_R_VALUE_HAS_BEEN_ALREADY_SET               218
# define RTENG_R_WRONG_CONTEXT                            219
# define RTENG_R_WRONG_CTRL                               220
# define RTENG_R_WRONG_ENGINE_ID                          221
# define RTENG_R_WRONG_KEK_LEN                            222
# define RTENG_R_WRONG_KEY                                223
# define RTENG_R_WRONG_KEY_LEN                            224
# define RTENG_R_WRONG_MAC_LEN                            225
# define RTENG_R_WRONG_PATTR_TYPE                         226
# define RTENG_R_WRONG_UKM_LEN                            227
# define RTENG_R_WRONG_URI                                228

# ifdef  __cplusplus
}
# endif
#endif
