/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2018, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
* Данный пример демонстрирует смену PIN на токене с помощью pkicore.     *
*************************************************************************/

#include <common.h>

using namespace std;
using namespace rutoken::pkicore;

int main()
{
	try {
		cout << boolalpha;

		/**********************************************************************
		* Инициализируем pkicore, передав путь до директории с библиотекой    *
		* rtPKCS11ECP.                                                        *
		**********************************************************************/
		rutoken::pkicore::initialize(".");
		SCOPE_EXIT() {
			/**********************************************************************
			* Завершаем работу с pkicore при выходе из текущего блока.            *
			**********************************************************************/
			rutoken::pkicore::deinitialize();
		};

		/**********************************************************************
		* Получаем список подключенных устройств и продолжаем работу с первым *
		* доступным устройством.                                              *
		**********************************************************************/
		auto devices = Pkcs11Device::enumerate();
		if (devices.empty()) {
			throw runtime_error("There must be at least one device connected");
		}

		auto device = move(devices.front());

		/**********************************************************************
		* Меняем PIN на новый.                                                *
		**********************************************************************/
		cout << "Setting new PIN" << endl;
		device.changePin("12345678", "123456");

		/**********************************************************************
		* Пытаемся аутентифицироваться со старым PIN.                         *
		**********************************************************************/
		try {
			cout << "Trying to login with old PIN" << endl;
			device.login("12345678");
		} catch (const error::IncorrectPinException&) {
			cout << "Got IncorrectPinException" << endl;
		}

		/**********************************************************************
		* Аутентифицируемся с новым PIN.                                      *
		**********************************************************************/
		cout << "Trying to login with new PIN" << endl;
		device.login("123456");

		/**********************************************************************
		* Меняем PIN обратно на старый.                                       *
		**********************************************************************/
		cout << "Changing PIN back" << endl;
		device.changePin("123456", "12345678");

		/**********************************************************************
		* Сбрасываем права доступа.                                           *
		**********************************************************************/
		cout << "Logging out" << endl;
		device.logout();
	} catch (const exception& e) {
		cerr << e.what() << endl;
		return 1;
	}

	return 0;
}
