/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import ru.rutoken.crypto.SpecSecretKey;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.PrivateKeyInterface;
import ru.rutoken.security.PublicKeyInterface;
import ru.rutoken.security.SpecPrivateKey;
import ru.rutoken.security.SpecPublicKey;

public class AgreementSpi
extends KeyAgreementSpi
implements Cleanable {
    protected PrivateKeyInterface privateKey;
    protected PublicKeyInterface publicKey;
    protected AlgorithmParameterSpec algorithmParameter;

    public void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == Cleaner.CleanPrivateKey.INSTANCE) {
            Cleaner.clean(this);
        } else {
            if (key instanceof SpecPrivateKey) {
                this.privateKey = ((SpecPrivateKey)key).getImpl();
            }
            this.algorithmParameter = algorithmParameterSpec;
        }
    }

    public Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException();
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
        if (key instanceof SpecPublicKey) {
            this.publicKey = ((SpecPublicKey)key).getImpl();
        }
        return null;
    }

    public byte[] engineGenerateSecret() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        throw new UnsupportedOperationException();
    }

    public SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.publicKey == null) {
            throw new IllegalStateException();
        }
        PublicKeyInterface publicKeyInterface = this.publicKey;
        this.publicKey = null;
        return new SpecSecretKey(this.privateKey.generateSecret(publicKeyInterface, this.algorithmParameter));
    }

    public void clean() {
        this.privateKey = null;
    }
}

