/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import ru.rutoken.crypto.SpecSecretKey;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.PrivateKeyInterface;
import ru.rutoken.security.PublicKeyInterface;
import ru.rutoken.security.SpecPrivateKey;
import ru.rutoken.security.SpecPublicKey;

public class KeyAgreement
implements Cleanable {
    protected final String algorithmName;
    protected PrivateKeyInterface privateKey;
    protected PublicKeyInterface publicKey;
    protected AlgorithmParameterSpec algorithmParameter;

    public KeyAgreement(String string) {
        this.algorithmName = string;
    }

    public static KeyAgreement getInstance(String string) throws NoSuchAlgorithmException {
        return new KeyAgreement(string);
    }

    public static KeyAgreement getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return new KeyAgreement(string);
    }

    public static KeyAgreement getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        return new KeyAgreement(string);
    }

    public String getAlgorithm() {
        return this.algorithmName;
    }

    public Provider getProvider() {
        return null;
    }

    public void init(Key key) throws InvalidKeyException {
        try {
            this.init(key, null, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.init(key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(key, algorithmParameterSpec, null);
    }

    public void init(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key instanceof SpecPrivateKey) {
            this.privateKey = ((SpecPrivateKey)key).getImpl();
        }
        this.algorithmParameter = algorithmParameterSpec;
    }

    public Key doPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException();
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
        if (key instanceof SpecPublicKey) {
            this.publicKey = ((SpecPublicKey)key).getImpl();
        }
        return null;
    }

    public byte[] generateSecret() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public int generateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        throw new UnsupportedOperationException();
    }

    public SecretKey generateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.publicKey == null) {
            throw new IllegalStateException();
        }
        PublicKeyInterface publicKeyInterface = this.publicKey;
        this.publicKey = null;
        return new SpecSecretKey(this.privateKey.generateSecret(publicKeyInterface, this.algorithmParameter));
    }

    public void clean() {
    }
}

