/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import ru.rutoken.crypto.KeyGenInterface;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.spec.ParamKeySize;
import ru.rutoken.security.spec.ParamRandom;

public class KeyGenSpi
extends KeyGeneratorSpi
implements Cleanable {
    protected final KeyGenInterface implementation;

    public KeyGenSpi(KeyGenInterface keyGenInterface) {
        this.implementation = keyGenInterface;
    }

    public void engineInit(SecureRandom secureRandom) {
        try {
            this.implementation.setParameter(new ParamRandom(secureRandom));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == Cleaner.ParamClean.INSTANCE) {
            Cleaner.clean(this);
        } else {
            this.implementation.setParameter(new ParamRandom(secureRandom));
            this.implementation.setParameter(algorithmParameterSpec);
        }
    }

    public void engineInit(int n, SecureRandom secureRandom) throws InvalidParameterException {
        try {
            this.implementation.setParameter(new ParamRandom(secureRandom));
            this.implementation.setParameter(new ParamKeySize(n));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public SecretKey engineGenerateKey() {
        return this.implementation.generateKey();
    }

    public void clean() {
        Cleaner.clean(this.implementation);
    }
}

