/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.crypto;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ShortBufferException;
import ru.rutoken.crypto.MacInterface;
import ru.rutoken.jrt11.impl.GostMac11;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.spec.gost.CryptParamFactory;
import ru.rutoken.tools.Arrays;

public class Mac
implements Cleanable {
    public static final char SEPARATOR = '/';
    public static final String STR_SEPARATOR = "/";
    protected final MacInterface implementation;
    protected byte[] tempArray;

    public Mac(MacInterface macInterface) {
        this.implementation = macInterface;
    }

    public static Mac getInstance(String string) throws NoSuchAlgorithmException {
        Object object;
        String string2 = null;
        if (string.indexOf(47) != -1) {
            object = string.split(STR_SEPARATOR);
            string = object[0];
            string2 = object[1];
        }
        if (!"rt11GOST28147".equalsIgnoreCase(string)) {
            throw new NoSuchAlgorithmException();
        }
        object = new GostMac11();
        if (string2 != null) {
            try {
                object.setParameter(CryptParamFactory.getInstance(string2));
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException();
                noSuchAlgorithmException.initCause(invalidAlgorithmParameterException);
                throw noSuchAlgorithmException;
            }
        }
        return new Mac((MacInterface)object);
    }

    public static Mac getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return Mac.getInstance(string);
    }

    public static Mac getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        return Mac.getInstance(string);
    }

    public Provider getProvider() {
        return null;
    }

    public String getAlgorithm() {
        return this.implementation.getAlgorithmName();
    }

    public void clean() {
        if (this.tempArray != null) {
            Arrays.clean(this.tempArray);
            this.tempArray = null;
        }
        Cleaner.clean(this.implementation);
    }

    public int getMacLength() {
        return this.implementation.getValueLength();
    }

    public void init(Key key) throws InvalidKeyException {
        this.implementation.init(key);
    }

    public void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.implementation.init(key);
        this.implementation.setParameter(algorithmParameterSpec);
    }

    public void update(byte by) throws IllegalStateException {
        byte[] byArray = new byte[]{by};
        this.implementation.update(byArray, 0, 1);
    }

    public void update(byte[] byArray) throws IllegalStateException {
        this.implementation.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) throws IllegalStateException {
        this.implementation.update(byArray, n, n2);
    }

    public void update(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset();
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            this.implementation.update(byArray, n + n2, n3 - n2);
            byteBuffer.position(n3);
        } else {
            int n = byteBuffer.remaining();
            int n4 = Arrays.getTempArraySize(n);
            if (this.tempArray == null || n4 > this.tempArray.length) {
                this.tempArray = new byte[n4];
            }
            while (n > 0) {
                int n5 = Math.min(n, this.tempArray.length);
                byteBuffer.get(this.tempArray, 0, n5);
                this.implementation.update(this.tempArray, 0, n5);
                n -= n5;
            }
        }
    }

    public byte[] doFinal() throws IllegalStateException {
        byte[] byArray = new byte[this.implementation.getValueLength()];
        this.implementation.doFinal(byArray, 0);
        this.implementation.reset();
        return byArray;
    }

    public void doFinal(byte[] byArray, int n) throws ShortBufferException, IllegalStateException {
        this.implementation.doFinal(byArray, n);
        this.implementation.reset();
    }

    public byte[] doFinal(byte[] byArray) throws IllegalStateException {
        this.implementation.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[this.implementation.getValueLength()];
        this.implementation.doFinal(byArray2, 0);
        this.implementation.reset();
        return byArray2;
    }

    public void reset() {
        this.implementation.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        return new Mac((MacInterface)this.implementation.clone());
    }

    public String toString() {
        return this.implementation.toString();
    }
}

