/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.crypto;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.crypto.MacInterface;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.tools.Arrays;

public class MacSpi
extends javax.crypto.MacSpi
implements Cleanable {
    protected final MacInterface implementation;
    protected byte[] tempArray;

    public MacSpi(MacInterface macInterface) {
        this.implementation = macInterface;
    }

    public int engineGetMacLength() {
        return this.implementation.getValueLength();
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.implementation.setParameter(algorithmParameterSpec);
    }

    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == Cleaner.ParamClean.INSTANCE) {
            Cleaner.clean(this);
        } else {
            this.implementation.init(key);
            this.implementation.setParameter(algorithmParameterSpec);
        }
    }

    public void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.implementation.update(byArray, 0, 1);
    }

    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.implementation.update(byArray, n, n2);
    }

    public void engineUpdate(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset();
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            this.implementation.update(byArray, n + n2, n3 - n2);
            byteBuffer.position(n3);
        } else {
            int n = byteBuffer.remaining();
            int n4 = Arrays.getTempArraySize(n);
            if (this.tempArray == null || n4 > this.tempArray.length) {
                this.tempArray = new byte[n4];
            }
            while (n > 0) {
                int n5 = Math.min(n, this.tempArray.length);
                byteBuffer.get(this.tempArray, 0, n5);
                this.implementation.update(this.tempArray, 0, n5);
                n -= n5;
            }
        }
    }

    public byte[] engineDoFinal() {
        byte[] byArray = new byte[this.implementation.getValueLength()];
        this.implementation.doFinal(byArray, 0);
        this.implementation.reset();
        return byArray;
    }

    public void engineReset() {
        this.implementation.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        return new MacSpi((MacInterface)this.implementation.clone());
    }

    public String toString() {
        return this.implementation.toString();
    }

    public void clean() {
        if (this.tempArray != null) {
            Arrays.clean(this.tempArray);
            this.tempArray = null;
        }
        Cleaner.clean(this.implementation);
    }
}

