/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.impl.PublicKey11;
import ru.rutoken.jrt11.level11.Attribute;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.PublicKeyInterface;
import ru.rutoken.security.spec.gost.EllipticParamFactory;
import ru.rutoken.security.spec.gost.EllipticParamInterface;
import ru.rutoken.security.spec.gost.ExchangeParamFactory;
import ru.rutoken.security.spec.gost.ExchangeParamInterface;

public class GostPublicKey11
extends PublicKey11 {
    public static final int PUBLIC_KEY_LENGTH = 64;
    public static final AttributeList CREATE_ATTRIBUTES = new AttributeList(new Attribute[]{Attribute.CLASS_PUBLIC_KEY, Attribute.TOKEN_TRUE, Attribute.PRIVATE_FALSE, Attribute.KEY_TYPE_GOSTR3410, Attribute.MODIFIABLE_TRUE, Attribute.GOSTR3410_PARAMS_DEFAULT, Attribute.ID_EMPTY, Attribute.LABEL_EMPTY});
    public static final AttributeList FIND_PUBLIC_KEYS_PATTERN = new AttributeList(new Attribute[]{Attribute.CLASS_PUBLIC_KEY, Attribute.TOKEN_TRUE, Attribute.PRIVATE_FALSE, Attribute.KEY_TYPE_GOSTR3410});

    public GostPublicKey11(TokenObj tokenObj) throws P11Exception {
        super(tokenObj);
    }

    public GostPublicKey11(byte[] byArray) throws P11Exception {
        super(null);
    }

    public GostPublicKey11(Session session, String string, String string2, byte[] byArray, EllipticParamInterface ellipticParamInterface) throws P11Exception {
        super(session.createObject(GostPublicKey11.getPlaceAttributes(string, string2, byArray, ellipticParamInterface)));
    }

    public String getAlgorithmName() {
        return "rtGOST3410";
    }

    public int getSignatureLength() {
        return 64;
    }

    protected Mechanism getVerifyMechanism() {
        return Mechanism.SIGN_GOST3410;
    }

    public AlgorithmParameterSpec getParameter() {
        try {
            Object object = this.tokenObject.getAttributeValue(592L);
            if (!(object instanceof byte[]) || ((byte[])object).length != 9) {
                throw new P11Exception("Invalid PublicKey attribute.");
            }
            EllipticParamInterface ellipticParamInterface = null;
            try {
                ellipticParamInterface = ExchangeParamFactory.decode((byte[])object, 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ellipticParamInterface = EllipticParamFactory.decode((byte[])object, 0);
            }
            return ellipticParamInterface;
        }
        catch (P11Exception p11Exception) {
            throw new ProviderException(p11Exception);
        }
    }

    public byte[] getValue() {
        Object object;
        try {
            object = this.tokenObject.getAttributeValue(17L);
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
        if (!(object instanceof byte[])) {
            throw new TokenException("Invalid PublicKey attribute.");
        }
        return (byte[])object;
    }

    public static AttributeList getCreatePattern(String string, String string2, EllipticParamInterface ellipticParamInterface) {
        AttributeList attributeList = new AttributeList(CREATE_ATTRIBUTES);
        attributeList.setValue(592L, ellipticParamInterface.getEncodedOID());
        if (ellipticParamInterface instanceof ExchangeParamInterface) {
            attributeList.add(new Attribute(268L, true));
        } else {
            attributeList.add(new Attribute(268L, false));
        }
        if (string != null) {
            attributeList.setValue(258L, string);
        }
        if (string2 != null) {
            attributeList.setValue(3L, string2);
        }
        return attributeList;
    }

    public static GostPublicKey11 create(Session session, String string, String string2, byte[] byArray, EllipticParamInterface ellipticParamInterface) throws TokenException {
        try {
            AttributeList attributeList = GostPublicKey11.getPlaceAttributes(string, string2, byArray, ellipticParamInterface);
            TokenObj tokenObj = session.createObject(attributeList);
            return new GostPublicKey11(tokenObj);
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    public static AttributeList getPlaceAttributes(String string, String string2, byte[] byArray, EllipticParamInterface ellipticParamInterface) {
        AttributeList attributeList = GostPublicKey11.getCreatePattern(string, string2, ellipticParamInterface);
        return attributeList.add(new Attribute(17L, byArray));
    }

    public static PublicKeyInterface[] findPublicKeys(Session session) throws P11Exception {
        TokenObj[] tokenObjArray = session.findObjects(FIND_PUBLIC_KEYS_PATTERN);
        PublicKeyInterface[] publicKeyInterfaceArray = new PublicKeyInterface[tokenObjArray.length];
        for (int i = 0; i < tokenObjArray.length; ++i) {
            publicKeyInterfaceArray[i] = new GostPublicKey11(tokenObjArray[i]);
        }
        return publicKeyInterfaceArray;
    }

    public static PublicKeyInterface findKeyById(Session session, String string) throws P11Exception {
        AttributeList attributeList = new AttributeList(FIND_PUBLIC_KEYS_PATTERN);
        attributeList.add(new Attribute(258L, string.getBytes()));
        TokenObj[] tokenObjArray = session.findObjects(attributeList);
        if (tokenObjArray.length > 1) {
            throw new P11Exception("Structure corrupted. Two keys with one name.");
        }
        return tokenObjArray.length == 0 ? null : new GostPublicKey11(tokenObjArray[0]);
    }
}

