/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import ru.rutoken.jrt11.impl.PrivateKey11;
import ru.rutoken.jrt11.level11.Attribute;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.PrivateKeyInterface;

public class RsaPrivateKey11
extends PrivateKey11 {
    public static final AttributeList CREATE_ATTRIBUTES = new AttributeList(new Attribute[]{Attribute.CLASS_PRIVATE_KEY, Attribute.TOKEN_TRUE, Attribute.PRIVATE_TRUE, Attribute.KEY_TYPE_RSA, Attribute.MODULUS_BITS_512, Attribute.ID_EMPTY, Attribute.LABEL_EMPTY});
    public static final AttributeList FIND_PRIVATE_KEYS_PATTERN = new AttributeList(new Attribute[]{Attribute.CLASS_PRIVATE_KEY, Attribute.TOKEN_TRUE, Attribute.PRIVATE_TRUE});

    public RsaPrivateKey11(TokenObj tokenObj) throws P11Exception {
        super(tokenObj);
    }

    public String getAlgorithmName() {
        return "rtRSA";
    }

    public int getSignatureLength() {
        return 64;
    }

    protected Mechanism getMechanism() {
        return Mechanism.SIGN_RSA;
    }

    public static AttributeList getCreatePattern(int n, String string, String string2) {
        AttributeList attributeList = new AttributeList(CREATE_ATTRIBUTES);
        if (n != 0) {
            attributeList.setValue(289L, n);
        }
        attributeList.setValue(258L, string);
        attributeList.setValue(3L, string2);
        return attributeList;
    }

    public static PrivateKeyInterface[] findPrivateKeys(Session session) throws P11Exception {
        TokenObj[] tokenObjArray = session.findObjects(FIND_PRIVATE_KEYS_PATTERN);
        PrivateKeyInterface[] privateKeyInterfaceArray = new PrivateKeyInterface[tokenObjArray.length];
        for (int i = 0; i < tokenObjArray.length; ++i) {
            privateKeyInterfaceArray[i] = new RsaPrivateKey11(tokenObjArray[i]);
        }
        return privateKeyInterfaceArray;
    }

    public static PrivateKeyInterface findKeyById(Session session, String string) throws P11Exception {
        AttributeList attributeList = new AttributeList(FIND_PRIVATE_KEYS_PATTERN);
        attributeList.add(new Attribute(258L, string.getBytes()));
        TokenObj[] tokenObjArray = session.findObjects(attributeList);
        if (tokenObjArray.length > 1) {
            throw new P11Exception("Structure corrupted. Two keys with one name.");
        }
        return tokenObjArray.length == 0 ? null : new RsaPrivateKey11(tokenObjArray[0]);
    }
}

