/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ShortBufferException;
import ru.rutoken.crypto.CipherInterface;
import ru.rutoken.crypto.CipherKeyInterface;
import ru.rutoken.crypto.KeyBlob;
import ru.rutoken.crypto.MacInterface;
import ru.rutoken.crypto.SecretKeyInterface;
import ru.rutoken.crypto.SpecSecretKey;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.impl.DataCollector;
import ru.rutoken.jrt11.impl.GostPrivateKey11;
import ru.rutoken.jrt11.impl.Rt11SecretKey;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.SpecPrivateKey;
import ru.rutoken.tools.Arrays;

public class Rt11CipherKey
extends Rt11SecretKey
implements CipherKeyInterface {
    protected DataCollector dataCollector = new DataCollector();
    protected CipherInterface cipherInterface = null;

    public Rt11CipherKey(Rt11SecretKey rt11SecretKey) throws P11Exception {
        super(rt11SecretKey);
    }

    public void reset() {
        this.dataCollector.reset();
    }

    public void macInit(MacInterface macInterface) {
        this.dataCollector.reset();
    }

    public void macUpdate(byte[] byArray, int n, int n2) {
        this.dataCollector.update(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void macFinal(byte[] byArray, int n) {
        byte[] byArray2 = null;
        try {
            byArray2 = this.dataCollector.toByteArray();
            this.macSingle(byArray2, 0, byArray2.length, byArray, n);
        }
        finally {
            Cleaner.clean(byArray2);
        }
    }

    public void macSingle(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        try {
            TokenObj tokenObj = this.getObject();
            Session session = tokenObj.getSession();
            session.macInit(tokenObj, Mechanism.MAC_GOST28147);
            byte[] byArray3 = session.macSingle(byArray);
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    public void encryptInit(CipherInterface cipherInterface) {
        this.cipherInterface = cipherInterface;
        this.dataCollector.reset();
    }

    public int encryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws ShortBufferException {
        this.dataCollector.update(byArray, n, n2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encryptFinal(byte[] byArray, int n, int n2) throws ShortBufferException {
        byte[] byArray2 = null;
        try {
            byArray2 = this.dataCollector.toByteArray();
            int n3 = this.encryptSingle(byArray2, 0, byArray2.length, byArray, n, n2);
            return n3;
        }
        finally {
            Cleaner.clean(byArray2);
        }
    }

    public int encryptSingle(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws ShortBufferException {
        try {
            Session session = this.tokenObject.getSession();
            Mechanism mechanism = this.cipherInterface.getMode() == 1 ? new Mechanism(4641L, null) : new Mechanism(4642L, this.cipherInterface.getIV());
            session.encryptInit(this.tokenObject, mechanism);
            return session.encryptSingle(byArray, n, n2, byArray2, n3, n4);
        }
        catch (P11Exception p11Exception) {
            ShortBufferException shortBufferException = new ShortBufferException(p11Exception.toString());
            shortBufferException.initCause(p11Exception);
            throw shortBufferException;
        }
    }

    public void decryptInit(CipherInterface cipherInterface) {
        this.cipherInterface = cipherInterface;
        this.dataCollector.reset();
    }

    public int decryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws ShortBufferException {
        this.dataCollector.update(byArray, n, n2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decryptFinal(byte[] byArray, int n, int n2) throws ShortBufferException {
        byte[] byArray2 = null;
        try {
            byArray2 = this.dataCollector.toByteArray();
            int n3 = this.decryptSingle(byArray2, 0, byArray2.length, byArray, n, n2);
            return n3;
        }
        finally {
            Cleaner.clean(byArray2);
        }
    }

    public int decryptSingle(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws ShortBufferException {
        try {
            Session session = this.tokenObject.getSession();
            Mechanism mechanism = this.cipherInterface.getMode() == 1 ? new Mechanism(4641L, null) : new Mechanism(4642L, this.cipherInterface.getIV());
            session.decryptInit(this.tokenObject, mechanism);
            return session.decryptSingle(byArray, n, n2, byArray2, n3, n4);
        }
        catch (P11Exception p11Exception) {
            ShortBufferException shortBufferException = new ShortBufferException(p11Exception.toString());
            shortBufferException.initCause(p11Exception);
            throw shortBufferException;
        }
    }

    public void clean() {
        try {
            this.tokenObject.delete();
        }
        catch (P11Exception p11Exception) {
            // empty catch block
        }
        Cleaner.clean(this.dataCollector);
        super.clean();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new Rt11CipherKey(this);
        }
        catch (P11Exception p11Exception) {
            CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException(p11Exception.toString());
            cloneNotSupportedException.initCause(p11Exception);
            throw cloneNotSupportedException;
        }
    }

    public KeyBlob wrap(SecretKeyInterface secretKeyInterface, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        if (secretKeyInterface instanceof Rt11SecretKey) {
            byte[] byArray;
            try {
                byArray = this.getObject().getSession().wrap(Mechanism.CIPHER_GOST28147_WRAP, this.getObject(), ((Rt11SecretKey)secretKeyInterface).getObject());
            }
            catch (P11Exception p11Exception) {
                throw new InvalidKeyException(p11Exception);
            }
            return new KeyBlob(byArray);
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key unwrap(KeyBlob keyBlob, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        void var6_10;
        TokenObj tokenObj;
        AttributeList attributeList = null;
        int n = 3;
        if (n == 3) {
            attributeList = Rt11SecretKey.CREATE_ATTRIBUTES;
        } else if (n == 2) {
            attributeList = GostPrivateKey11.CREATE_ATTRIBUTES;
        }
        try {
            byte[] byArray = keyBlob.encode();
            tokenObj = this.getObject().getSession().unwrap(Mechanism.CIPHER_GOST28147_WRAP, this.getObject(), byArray, attributeList);
        }
        catch (P11Exception p11Exception) {
            throw new InvalidKeyException(p11Exception);
        }
        Object var6_7 = null;
        byte[] byArray = null;
        try {
            if (n == 3) {
                byArray = (byte[])tokenObj.getAttributeValue(17L);
                SpecSecretKey specSecretKey = new SpecSecretKey(new Rt11SecretKey(tokenObj, byArray));
            } else if (n == 2) {
                SpecPrivateKey specPrivateKey = new SpecPrivateKey(new GostPrivateKey11(tokenObj));
            }
            if (byArray == null) return var6_10;
        }
        catch (P11Exception p11Exception) {
            try {
                throw new InvalidKeyException(p11Exception);
            }
            catch (Throwable throwable) {
                if (byArray == null) throw throwable;
                Arrays.clean(byArray);
                throw throwable;
            }
        }
        Arrays.clean(byArray);
        return var6_10;
    }
}

