/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.jrt11.impl.GostPairGenerator11;
import ru.rutoken.jrt11.impl.RsaPairGenerator11;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.PairGeneratorInterface;
import ru.rutoken.security.SecureRandom;
import ru.rutoken.security.spec.ParamKeySize;
import ru.rutoken.security.spec.gost.EllipticParamFactory;
import ru.rutoken.security.spec.gost.ExchangeParamFactory;

public class KeyPairGenerator
implements Cleanable {
    public static final char SEPARATOR = '/';
    public static final String STR_SEPARATOR = "/";
    protected final PairGeneratorInterface implementation;

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        Object object;
        String string2 = null;
        if (string.indexOf(47) != -1) {
            object = string.split(STR_SEPARATOR);
            string = object[0];
            string2 = object[1];
        }
        if ("rtGOST3410".equalsIgnoreCase(string)) {
            object = new GostPairGenerator11();
        } else if ("rtRSA".equalsIgnoreCase(string)) {
            object = new RsaPairGenerator11();
        } else {
            throw new NoSuchAlgorithmException();
        }
        if (string2 != null) {
            try {
                object.setParameter(KeyPairGenerator.getParam(string2));
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException();
                noSuchAlgorithmException.initCause(invalidAlgorithmParameterException);
                throw noSuchAlgorithmException;
            }
        }
        return new KeyPairGenerator((PairGeneratorInterface)object);
    }

    public static KeyPairGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(string);
    }

    public static KeyPairGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(string);
    }

    public static AlgorithmParameterSpec getParam(String string) throws InvalidAlgorithmParameterException {
        try {
            return ExchangeParamFactory.getInstance(string);
        }
        catch (Exception exception) {
            return EllipticParamFactory.getInstance(string);
        }
    }

    public KeyPairGenerator(PairGeneratorInterface pairGeneratorInterface) {
        this.implementation = pairGeneratorInterface;
    }

    public String getAlgorithm() {
        return this.implementation.getAlgorithmName();
    }

    public Provider getProvider() {
        return null;
    }

    public void clean() {
        Cleaner.clean(this.implementation);
    }

    public void initialize(int n) {
        try {
            this.implementation.setParameter(new ParamKeySize(n));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void initialize(int n, SecureRandom secureRandom) {
        try {
            this.implementation.setParameter(new ParamKeySize(n));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.implementation.setParameter(algorithmParameterSpec);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.implementation.setParameter(algorithmParameterSpec);
    }

    public KeyPair generateKeyPair() {
        return this.implementation.generateKeyPair();
    }

    public String toString() {
        return this.implementation.toString();
    }
}

