/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import ru.rutoken.crypto.KeyBlob;
import ru.rutoken.crypto.SecretKeyInterface;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.PublicKeyInterface;

public interface PrivateKeyInterface
extends KeySpec,
Cloneable,
Cleanable {
    public String getAlgorithmName();

    public int getSignatureLength();

    public void setParameter(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    public AlgorithmParameterSpec getParameter();

    public PublicKeyInterface generatePublic() throws InvalidKeyException;

    public byte[] signature(byte[] var1) throws SignatureException, InvalidKeyException;

    public SecretKeyInterface generateSecret(PublicKeyInterface var1, AlgorithmParameterSpec var2) throws InvalidKeyException;

    public KeyBlob exportKey(SecretKeyInterface var1, AlgorithmParameterSpec var2) throws InvalidKeyException;

    public void importKey(KeyBlob var1, SecretKeyInterface var2, AlgorithmParameterSpec var3) throws InvalidKeyException;

    public Object clone() throws CloneNotSupportedException;
}

