/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security.spec.gost;

import ru.rutoken.security.spec.EllipticCurve;
import ru.rutoken.security.spec.OID;
import ru.rutoken.security.spec.gost.EllipticParamInterface;

public class EllipticParamSpec
implements EllipticParamInterface {
    public static final int[] INTS_SET_TEST = new int[]{1, 2, 643, 2, 2, 35, 0};
    public static final int[] INTS_SET_A = new int[]{1, 2, 643, 2, 2, 35, 1};
    public static final int[] INTS_SET_B = new int[]{1, 2, 643, 2, 2, 35, 2};
    public static final int[] INTS_SET_C = new int[]{1, 2, 643, 2, 2, 35, 3};
    public static final String STR_SET_TEST = "1.2.643.2.2.35.0";
    public static final String STR_SET_A = "1.2.643.2.2.35.1";
    public static final String STR_SET_B = "1.2.643.2.2.35.2";
    public static final String STR_SET_C = "1.2.643.2.2.35.3";
    public static final byte[] ENCODED_TEST = new byte[]{6, 7, 42, -123, 3, 2, 2, 35, 0};
    public static final byte[] ENCODED_SET_A = new byte[]{6, 7, 42, -123, 3, 2, 2, 35, 1};
    public static final byte[] ENCODED_SET_B = new byte[]{6, 7, 42, -123, 3, 2, 2, 35, 2};
    public static final byte[] ENCODED_SET_C = new byte[]{6, 7, 42, -123, 3, 2, 2, 35, 3};
    public static final OID[] OID_LIST = new OID[]{new OID(INTS_SET_TEST), new OID(INTS_SET_A), new OID(INTS_SET_B), new OID(INTS_SET_C)};
    public static final String[] STRING_LIST = new String[]{"1.2.643.2.2.35.0", "1.2.643.2.2.35.1", "1.2.643.2.2.35.2", "1.2.643.2.2.35.3"};
    public static final byte[][] ENCODED_LIST = new byte[][]{ENCODED_TEST, ENCODED_SET_A, ENCODED_SET_B, ENCODED_SET_C};
    protected final int index;

    public EllipticParamSpec(int n) {
        if (n < 0 || n > OID_LIST.length) {
            throw new IllegalArgumentException();
        }
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public int[] getP() {
        return null;
    }

    public int[] getQ() {
        return null;
    }

    public EllipticCurve getCurve() {
        return null;
    }

    public OID getOID() {
        return OID_LIST[this.index];
    }

    public byte[] getEncodedOID() {
        return ENCODED_LIST[this.index];
    }

    public String toString() {
        return STRING_LIST[this.index];
    }

    public boolean equals(Object object) {
        return object instanceof EllipticParamSpec && this.index == ((EllipticParamSpec)object).index;
    }

    public int hashCode() {
        return this.index;
    }
}

