/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2017, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
* В данном файле содержится объявление следующих вспомогательных         *
* функций для работы с Рутокен при помощи программы Cert2Cont:           *
*  - получения имен контейнеров без сертификатов;                        *
*  - проверки наличия сертификата в контейнере;                          *
*  - проверки наличия сертификата для пары с заданным типом.             *
*************************************************************************/


#ifndef _CONTAINERS_H
#define _CONTAINERS_H


/************************************************************************
* Получить имена контейнеров, не содержащих сертификат                  *
************************************************************************/
BOOL EnumContainers(IN LPWSTR lpszCSPs[],         // Массив указателей на строки с именами криптопровайдеров
                    IN DWORD pdwCSPTypes[],       // Массив типов криптопровайдеров
                    IN DWORD dwSelectedCSP,       // Порядковый номер элемента в массиве имен и массиве типов криптопровайдеров
                    OUT LPWSTR lpszContainers[],  // Указатель на массив строк с именами контейнеров, не содержащих сертификат
                    OUT DWORD* pdwContainersCount // Количество элементов в массиве имен контейнеров
                    );

/************************************************************************
* Проверить наличие сертификата в контейнере                            *
************************************************************************/
BOOL CheckCertificateInContainer(IN LPCWSTR lpszCSP,             // Указатель на имя криптопровайдера
                                 IN DWORD dwCryptProvType,       // Тип криптопровайдера
                                 IN LPCWSTR lpszContainer,       // Указатель на имя контейнера
                                 OUT BOOL* pbCertificateExists   // Если TRUE, то сертификат присутствует в контейнере, если FALSE - отсутствует
                                 );

/************************************************************************
* Проверить наличие сертификата для пары с заданным типом               *
************************************************************************/
BOOL CheckKeyCertificate(IN HCRYPTPROV hCryptProv,          // Хэндл криптопровайдера, открытый над заданным контейнером
                         IN DWORD dwKeySpec,                // Тип ключевого использования пары, для которой проверяется наличие сертификата
                         OUT BOOL* pbCertificateExists      // Если TRUE, то сертификат присутствует в контейнере, если FALSE - отсутствует
                         );

/************************************************************************
* Получить порядковый номер элемента в массиве имен контейнеров,        *
* для которого имя контейнера из массива совпадает с именем             *
* контейнера, переданным пользователем                                  *
************************************************************************/
DWORD SelectContainer(IN LPCWSTR lpszPreferredContainer, // Указатель на строку с именем контейнера, переданным пользователем
                      IN LPWSTR pbtContainers[],         // Указатель на массив строк с именами контейнеров, не содержащих сертификат
                      IN DWORD dwContainersCount         // Количество элементов в массиве имен контейнеров
                      );

#endif                // _CONTAINERS_H
