/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2017, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
* В данном файле содержится объявление следующих вспомогательных         *
* функций для работы с Рутокен при помощи программы Cert2Cont:           *
*  - печати сообщений в командной строке;                                *
*  - анализа параметров, переданных в командной строке;                  *
*  - чтения сертификата из файла;                                        *
*  - освобождения использованных ресурсов.                               *
*************************************************************************/


#ifndef _UTIL_FUNCS_H
#define _UTIL_FUNCS_H


/************************************************************************
* Распечатать приветствие                                               *
************************************************************************/
void PrintWelcomeInformation();

/************************************************************************
* Распечатать справочную информацию                                     *
************************************************************************/
void PrintHelpInformation();

/************************************************************************
* Проанализировать параметры, переданные в командной строке             *
************************************************************************/
BOOL ParseCommandLine(IN int argc,                     // Количество переданных в командной строке параметров
                      IN WCHAR* argv[],                // Массив указателей на строки с параметрами
                      OUT LPWSTR* lpszCSP,             // Указатель на строку, содержащую имя криптопровайдера
                      OUT LPWSTR* lpszContainer,       // Указатель на строку, содержащую имя контейнера
                      OUT DWORD* pdwKeySpec,           // Тип ключевого использования
                      OUT LPWSTR* lpszCertFileName,    // Указатель на строку, содержащую полный путь к файлу с сертификатом
                      OUT BOOL* bPrintHelpAndExit      // Если TRUE, то необходимо распечатать справку и завершить работу
                      );

/************************************************************************
* Считать сертификат из файла                                           *
************************************************************************/
BOOL ReadCertificateFromFile(IN LPCWSTR lpszPreferredFile,   // Указатель на строку, содержащую полный путь к файлу с сертификатом
                             OUT LPVOID* lpvCertBuffer,      // Указатель на буфер, в который будет помещен считанный сертификат
                             OUT DWORD* dwCertBufferSize     // Размер буфера, хранящего считанный сертификат, в байтах
                             );

/************************************************************************
* Освободить ресурсы, доступные по указателям массива указателей        *
************************************************************************/
void FreePointersList(IN LPWSTR* lpszPointersList,  // Указатель на массив указателей на строки
                      IN DWORD dwPointersCount      // Количество элементов в массиве
                      );

/************************************************************************
* Распечатать сообщение об ошибке                                       *
************************************************************************/
void PrintErrorText(IN LPWSTR lpszText,  // Указатель на строку с текстом
                    IN DWORD dwError     // Код ошибки
                    );

#endif                    // _UTIL_FUNCS_H
