/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2017, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
* Данный файл содержит объявление констант для работы с Рутокен и        *
* криптопровайдером КриптоПРО CSP через CryptoAPI на языке С             *
*************************************************************************/

#ifndef Common_H
#define Common_H

/*************************************************************************
* Включение файлов:                                                      *
*  - stdio.h - для доступа к библиотеке стандартного ввода/вывода        *
*  - Windows.h - для доступа к функциям Win32API                         *
*  - WinCrypt.h - для доступа к функциям CryptoAPI                       *
*  - string.h - для доступа к функциям для работы со строками            *
*  - stdlib.h - для доступа к стандартной библиотеке выделения памяти    *
*  - CSP_WinDef.h - для работы КриптоПРО CSP на *nix-платформах          *
*  - CSP_WinCrypt.h - для работы КриптоПРО CSP на *nix-платформах        *
*  - WinCryptEx.h - для доступа к определениям констант КриптоПРО CSP    *
*************************************************************************/

#include <stdio.h>
#ifdef _WIN32
#   include <Windows.h>
#   include <WinCrypt.h>
#else
#   include <string.h>
#   include <stdlib.h>
#   include <CSP_WinDef.h>
#   include <CSP_WinCrypt.h>
#endif
#include <WinCryptEx.h>

/************************************************************************
* Макросы                                                               *
************************************************************************/

/* Вычисление размера массива */
#define GetArraySize(a) sizeof(a) / sizeof(a[0])

/* Максимальное количество установленных криптопровайдеров */
#define MAX_PROV 100
/* Максимальное количество контейнеров на токене */
#define MAX_CONT 50

/************************************************************************
* Имена и типы криптопровайдеров                                        *
************************************************************************/

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2001 Cryptographic Service Provider" */
#define CRYPTOPRO_PROV_A CP_GR3410_2001_PROV_A

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2001 Cryptographic Service Provider" */
#define CRYPTOPRO_PROV_W CP_GR3410_2001_PROV_W

/* Криптопровайдер "GOST R 34.10-2001 Rutoken CSP" для ФКН */
#define CRYPTOPRO_FKN_PROV_A CP_KC1_GR3410_2001_RUTOKEN_PROV_A

/* Криптопровайдер "GOST R 34.10-2001 Rutoken CSP" для ФКН */
#define CRYPTOPRO_FKN_PROV_W CP_KC1_GR3410_2001_RUTOKEN_PROV_W

/* Тип криптопровайдера КриптоПРО CSP */
#define CRYPTOPRO_PROV_TYPE PROV_GOST_2001_DH

/************************************************************************
* Алгоритмы криптопровайдера                                            *
************************************************************************/

/* Алгоритм цифровой подписи ГОСТ Р 34.10-2001 */
#define OID_GOST3410 szOID_CP_GOST_R3411_R3410EL

/* Функция хэширования ГОСТ Р 34.11-94 */
#define OID_GOST3411 szOID_CP_GOST_R3411

/* Идентификатор алгоритма хэширования ГОСТ Р 34.11-94 */
#define ALG_GOST3411 CALG_GR3411

/* Параметры ГОСТ Р 34.11-94 по умолчанию */
#define GOST3411_PARAMS OID_HashVerbaO

/* Тип кодирования */
#define ENC_TYPE (X509_ASN_ENCODING | PKCS_7_ASN_ENCODING)

/************************************************************************
* Вспомогательные переменные                                            *
************************************************************************/

/* DEMO имя ключевого контейнера */
static LPWSTR CONT_NAME_W = L"RUTOKEN DEMO CONTAINER";
static LPCSTR FQCN_CONT_NAME = "\\\\.\\Aktiv Rutoken ECP 0\\RUTOKEN DEMO CONTAINER";

/* DEMO PIN-код Пользователя Рутокен */
static BYTE USER_PIN[] = "12345678";

/* DEMO поля сертификата */
static LPCWSTR SUBJECT_NAME_W = L"CN=TestCert, L=Moscow, O=AktivCo, E=hotline@rutoken.ru, T=Test";

/* Имя субъекта в сертификате */
static LPCWSTR CERT_SUBJECT_NAME_W = L"TestCert";

static BYTE KEY_USAGE = CERT_DIGITAL_SIGNATURE_KEY_USAGE | CERT_NON_REPUDIATION_KEY_USAGE;
static char* EXT_KEY_USAGE[] = { szOID_PKIX_KP_CLIENT_AUTH };

/* DEMO сообщение для подписи */
static BYTE* MSG_TO_SIGN = (BYTE*)"An example of plaintext to sign";

#endif //PKCS11_COMMON_H
