/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2017, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/



package ru.rutoken.pkcs11smsample;

/**
 * @author Aktiv Co. <hotline@rutoken.ru>
 */

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.app.Activity;
import android.text.InputType;
import android.view.View;
import android.widget.EditText;

import java.nio.charset.Charset;

public class MainActivity extends Activity {
    AlertDialog mSmInputPasswordDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);

        mSmInputPasswordDialog = createSmInputPasswordDialog();
    }

    protected AlertDialog createSmInputPasswordDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("SM password");

        final EditText input = new EditText(this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        builder.setView(input);

        builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                byte[] password = input.getText().toString().getBytes(Charset.forName("US-ASCII"));
                onStartSmOkButtonClick(password);
            }
        });
        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        return builder.create();
    }

    public void onGetInfoClick(View view) {
        switch (view.getId()) {
            case R.id.getTokenInfoButton:
                Intent intent = new Intent(MainActivity.this, Pkcs11SampleActivity.class);
                intent.putExtra("sampleType", Pkcs11SampleActivity.SampleType.getTokenInfo);
                startActivity(intent);
            default:
                break;
        }
    }

    public void onHashDataButtonClick(View view) {
        switch (view.getId()) {
            case R.id.hashDataButton:
                Intent intent = new Intent(MainActivity.this, Pkcs11SampleActivity.class);
                intent.putExtra("sampleType", Pkcs11SampleActivity.SampleType.hashData);
                startActivity(intent);
            default:
                break;
        }
    }

    public void onStartSmOkButtonClick(byte[] password) {
        Intent intent = new Intent(MainActivity.this, Pkcs11SampleActivity.class);
        intent.putExtra("sampleType", Pkcs11SampleActivity.SampleType.startSm);
        intent.putExtra("password", password);
        startActivity(intent);
    }

    public void onStartSmButtonClick(View view) {
        switch (view.getId()) {
            case R.id.startSmButton:
                mSmInputPasswordDialog.show();
            default:
                break;
        }
    }
}
