#import <Foundation/Foundation.h>

typedef enum _ReaderStatus {
	kValidReader,
	kNoMediaReader,
	kErrorReader
} ReaderStatus;

@interface CPReader : NSObject
@property (strong, readonly) NSString* nickname;
@property (strong, readonly) NSString* name;
@property (strong, readonly) NSString* media;
@property (assign, readonly) uint8_t flags;

- (CPReader*)initWithData:(uint8_t*)dataPtr;
- (ReaderStatus)getReaderStatus;
- (bool)isRutoken;
- (NSComparisonResult)localizedCaseInsensitiveCompare:(CPReader*)reader;
@end
