#	Rutoken PKCS#11 Spy installation script
#	
#	Keep in folder with librtpkcs11-spy.dylib library. Need to launch as root. 
#
#	Usage:
#
#	Possible arguments are:
#	
#	1. -l/--lib specifies path librtpkcs11ecp.dylib. If not set then default
#		value "/Library/Aktiv Co/Rutoken ECP/lib/librtpkcs11ecp_origin.dylib" used.
#
#	2. -u/--uninstall deletes Rutoken PKCS#11 Spy. 
#
#	3. -o/--out specifies path to log file. Default value is /Library/Logs/rutoken/pkcs11spy/log.log
#
while [[ $# -gt 0 ]] 	#	Parse arguments
do
	key="$1" 
	case $key in 
		-l |--lib)
			oldPath="$2"
			shift 2
		;;
		-o |--out)
			output="$2"
			shift 2
		;;
		-u |--uninstall)
			uninst=true
			shift
		;;
		*)
			shift
		;;
	esac
done

if [ -z "$oldPath" ] # librtpkcs11ecp.dylib oldPath is empty
then
	oldPath="/Library/Aktiv Co/Rutoken ECP/lib/librtpkcs11ecp.dylib"
	newPath="/Library/Aktiv Co/Rutoken ECP/lib/librtpkcs11ecp_origin.dylib"
else
	newPath="$(dirname "$oldPath")/librtpkcs11ecp_origin.dylib"
fi

if [ -z "$output" ] # librtpkcs11ecp.dylib oldPath is empty
then
	output="/Library/Logs/rutoken/pkcs11spy/log.log"
fi


if [ -z $uninst ] # Installing
then
	plistPath="/Library/Preferences/ru.rutoken.pkcs11spy.plist"	#	Create plist in /Library/Preferences/
	var=$(touch $plistPath)

	if [ $? == 0 ] #success
	then
		plistData="
					<?xml version="1.0" encoding="UTF-8"?>
					<!DOCTYPE >
					<plist version="1.0">
					<dict>
						<key>RT_PKCS11SPY</key>
						<string>$newPath</string>
						<key>RT_PKCS11SPY_OUTPUT</key>
						<string>$output</string>
					</dict>
					</plist>
				  "
		echo $plistData > $plistPath
	else
		echo "Property list file can't be created. Please run this as root!"
		exit 1
	fi

	if [ -f "$newPath" ]
	then
		echo "Rutoken PKCS#11 Spy is already installed. Please, uninstall it first."
		exit 2
	fi

	var=$(mv "$oldPath" "$newPath")	#	Rename librtpkcs11ecp.dylib to librtpkcs11ecp_origin.dylib

	if [ $? -gt "0" ] #failure
	then
		echo "Library \"$oldPath\" can't be renamed!"
		exit 3
	fi

	spyPath="$(dirname "$0")/librtpkcs11-spy.dylib" 	#	Copy Rutoken PKCS#11 SPY to destination folder
	var=$(cp "$spyPath" "$oldPath")

	if [ $? -ne "0" ] #failure
	then
		echo "Library \"$spyPath\" can't be copied! Aborting changes."
		var=$(mv "$newPath" "$oldPath")
		exit 4
	fi

	folder="$(dirname $output)"
	if [ ! -d "$folder" ]
	then
		var="$(mkdir -p $folder)"
	fi
	var="$(touch $output)"
	var="$(chmod 777 $output)"

	echo "Rutoken PKCS#11 Spy has been successfully installed! Restart to let changes take effect."

else # uninstall
	spyPath="$(dirname "$0")/librtpkcs11-spy.dylib" # path of original spy
	var="$(diff "$oldPath" "$spyPath")"

	if [ "$var" ]
	then
		echo "Rutoken PKCS#11 Spy is not installed!"
		exit 5
	fi

	var="$(rm "$oldPath")" 	#	Delete Rutoken PKCS#11 SPY

	if [ $? -gt "0" ]
	then
		echo "Library \"$oldPath\" can't be removed!"
		exit 6
	fi

	var=$(mv "$newPath" "$oldPath")	#	Rename librtpkcs11ecp_origin.dylib to librtpkcs11ecp.dylib

	if [ $? -gt "0" ] #failure
	then
		echo "Library \"$newPath\" can't be renamed!"
		exit 8
	fi

	plistPath="/Library/Preferences/ru.rutoken.pkcs11spy.plist"
	var=$(rm $plistPath)

	echo "Rutoken PKCS#11 Spy has been successfully removed! Restart to let changes take effect."
fi